<?php
require "../../../src/config.php";

//check permissions
if (!auth::isadmin()) {
    router::redirect("home");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $query = $_POST['query'];
    $data = datatable::query($query);
}

//page setup
page::set([
    "title" => "Query",
    "size" => "box-full",
    "layout" => "admin"
]);

page::header();
?>

<div class="card">
    <div class="card-body">
        <div class="list text-sm">

            <?php if ($_SERVER['REQUEST_METHOD'] == 'POST') {

                if ($data['success']) {
                    if ($data['count'] > 0) {
                        echo $data['count'] . " records";
                        display_table($data['data']);
                    } else {
                        echo "No records";
                    }
                } else {
                    display($data['error']);
                }
            } ?>

        </div>
    </div>

</div>

</form>

<?php page::footer(); ?>