<?php
require "../../src/config.php";

//check permissions
if (!auth::isadmin()) {
    router::redirect("home");
}

page::set([
    "title" => "Provincial institutions",
    "nav-parent" => "admin_institutions",
    "layout" => "admin",
    "size" => "box-full"
]);

page::header();
?>

<div class="card">
    <div class="card-body">
        <div id="list"></div>
    </div>
</div>


<script id="template" type="text/template">

    <div class="datalist">

        {{#data}}
        <div class="listitem" id="{{ins_id}}">

            <a href="update?id={{ins_id}}">
                    
                <div class="listitem-content">

                    <div class="row">

                        <div class="col col-w3">
                            <span class="text-muted text-xs">#{{ins_id}}</span>
                        </div>

                        <div class="col">
                            <span>{{ins_name}}</span>
                        </div>

                        <div class="col-w2">
                            {{#sender}}
                            <span class="text-info"><?= UI::icon("mail") ?></span>
                            {{/sender}}
                        </div>
                        
                        <div class="col-w2">
                            {{#receiver}}
                            <span class="text-success"><?= UI::icon("active") ?></span>
                            {{/receiver}}
                        </div>

                        <div class="col-w2">
                            {{#priority}}
                            <span class="text-warning"><?= UI::icon("star") ?></span>
                            {{/priority}}
                        </div>

                        <div class="col-w10">
                            <span class="text-xs tag-{{codename}}">{{shortname}}</span>
                        </div>
                    </div>
                    
                </div>

            </a>

        </div>
        {{/data}}

    </div>
    
</script>

<script src="script.js"></script>

<script>
    $(function() {
        show();
        //$('[data-toggle="tooltip"]').tooltip();
    });
</script>


<?php page::footer(); ?>