<?php
require "../../../src/config.php";

//check permissions
if (!auth::isadmin()) {
    router::redirect("home");
}

if (page::submitted()) {

    $data = $_POST;

    if (isset($_GET['id'])) {
        $response = institutions::update($_GET['id'], $data);
        if ($response["success"]) {
            //header("Location: ../update?id=" . $_GET["id"]);
        }
    } else {
        $response = institutions::create($data);
        if ($response["success"]) {
            header("Location: ../update?id=" . $response["id"]);
        }
    }

    if ($response["success"]) {
        header("Location: ../");
    } else {
        // wait
    }
} else if (isset($_GET['id'])) {
    $data = institutions::get($_GET['id']);
} else {
    $data = institutions::defaults();
}

page::set([
    "title" => "Update Organization",
    "layout" => "admin",
    "nav-parent" => "admin_institutions",
    "scripts" => ["chosen"],
    "size" => "box-lg"
]);

page::header();
?>

<form class="card" method="post" enctype="multipart/form-data">

    <div class="card-title">
        <div class="title"><?= UI::icon("institution") ?> <?= isset($_GET['id']) ? "Update Institution #" . $_GET['id'] : "New Institution" ?></div>
    </div>

    <div class="card-body">

        <?php
        if (page::submitted()) {
            form::response_summary($response);
        }
        ?>

        <div class="form-group">
            <label for="name">Name</label>
            <input name="ins_name" id="ins_name" class="form-control" placeholder="Name" type="text" value="<?= $data["ins_name"] ?>" required>
        </div>

        <div class="form-group">
            <label for="institution">Parent Institution</label>
            <div class="input-group">
                <select name="parent" id="parent" class="form-control">
                    <option value="0">None</option>
                    <?php foreach (institutions::parents() as $value) {
                        echo '<option value="' . $value['ins_id'] . '" ' . ($value["ins_id"] == $data["parent"] ? "selected" : "") . '>' . $value['ins_name'] . '</option>';
                    }  ?>
                </select>
            </div>
        </div>


    </div>

    <div class="card-bottom">

        <div class="row">
            <div class="col">
                <button type="submit" class="btn btn-primary btn-block"><?= isset($_GET['id']) ? "Update" : "Create" ?></button>
            </div>
            <div class="col">
                <a href="../" class="btn btn-dark btn-block">Back</a>
            </div>
        </div>


    </div>

</form>

<script>
    function update_image(input) {

        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#logo').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#parent").chosen({
        no_results_text: "ගැලපෙන ආයතනයක් නොමැත ...."
    });

    $('form').submit(function() {
        $(".card-bottom").html(UI_loading);
    });
</script>

<?php page::footer(); ?>