<?php

require "../../../src/config.php";

if (auth::isadmin() && isset($_GET['id'])) {
    $user_id = $_GET['id'];
} else if (auth::user()) {
    $user_id = auth::user();
} else {
    router::redirect("login");
}

$user = users::get($user_id);

if (!$user) {
    error("Profile does not exist");
}

$user = users::get($user_id);
$lastseen = users::lastseen($user_id);

page::set([
    "title" => "Profile",
    "nav-parent" => "user_profile",
    "size" => "box-lg",
    "layout" => "admin"
]);

page::header();
?>

<div class="card">

    <div class="card-top">
        <div class="title"><?= $user['name'] ?></div>
    </div>

    <div class="card-body">

        <div class="list">

            <div class="listitem">
                <div class="row listitem-content">
                    <div class="col li-icon">
                        <?= UI::icon("profile") ?>
                    </div>
                    <div class="col">
                        <div class="list-title"> <?= $user['name'] ?></div>

                        <div class="list-text text-xs ">

                            <?php if ($lastseen) { ?>
                                Last seen <?= timefrom($lastseen)  ?>
                            <?php } else { ?>
                                Never logged in
                            <?php } ?>

                        </div>

                        <a class="btn btn-primary my-2 text-light" href="update?id=<?= $user_id ?>">Update</a>


                    </div>

                </div>

            </div>

            <?php if (userroles::assigned($user_id) || auth::isadmin()) { ?>

                <div class="listitem">
                    <div class="row listitem-content">
                        <div class="col li-icon">
                            <?= UI::icon("role") ?>
                        </div>
                        <div class="col">

                            <div class=" ">

                                <div class="list-title">Assigned Roles</div>

                                <div class="li-text my-2">

                                    <?php foreach (userroles::types() as $role) { ?>
                                        <div class="row text-sm">
                                            <?php if (userroles::is_assigned($role["code"], $user_id)) { ?>
                                                <div class="col w-2 text-success"><?= UI::icon("success") ?></div>
                                                <div class="col"><?= $role['name'] ?></div>

                                            <?php } else { ?>
                                                <div class="col w-2 text-muted2"><?= UI::icon("lock") ?></div>

                                                <div class="col text-muted2"><?= $role['name'] ?></div>

                                            <?php  }  ?>

                                        </div>

                                    <?php } ?>

                                </div>

                                <?php if (auth::isadmin()) { ?>

                                    <?php if (users::get($user_id)) { ?>
                                        <a role="button" class="btn btn-primary my-1 text-light" href="/<?= SUBFOLDER ?>admin/users/profile/roles?id=<?= $user_id ?>">Update Roles</a>
                                    <?php } ?>
                                <?php } ?>

                            </div>
                        </div>

                    </div>

                </div>

            <?php } ?>

        </div>

    </div>
    <div class="card-bottom">

    </div>

</div>

<?php page::footer(); ?>