<?php
include "../../src/config.php";

if (!isset($_GET["category"])) {
    endrequest("Invalid request");
}

$query = "SELECT
    a.*,
    ROUND(a.filesize/1048576,2) as filesize
FROM 
    mis_archive as a
WHERE 
a.category = :category AND
a.visible = 1";

$response = datatable::query($query, ["category" => $_GET["category"]]);

foreach ($response["data"] as $key => $value) {
    // Icon
    $response["data"][$key]["icon"] = UI::icon("file-" . $value["filetype"]);
    // File Availability
    if (file_exists(FILE_ROOT . "modules/archive/files/" . $value["hash"] . "." . $value["filetype"])) {
        $response["data"][$key]["file"] = true;
    } else {
        $response["data"][$key]["file"] = false;
    }
}

echo json_encode($response);
