<?php
include "../../src/config.php";

$data = [];

$monthnames = ["ඉරිදා", "සඳුදා", "අඟහරුවාදා", "බදාදා", "බ්‍රහස්පතින්දා", "සිකුරාදා", "සෙනසුරාදා"];

$start_date = new DateTime();
$last_date = (new DateTime())->modify("last day of +12 month");

for ($date = $start_date; $date <= $last_date; $date->modify('+1 day')) {

    $data[date_format($date, "Y-m-d")] = [
        "date" => date_format($date, "d"),
        "day" => date_format($date, "D"),
        "day_sin" => $monthnames[date_format($date, "w")],
        "month_shortname" => date_format($date, "M"),
        "isweekend" => in_array(date_format($date, "l"), ["Saturday", "Sunday"]),
        "isbusy" => false
    ];
}


$userdiary_query = "SELECT
id,
duedate, 
note,
state
FROM mis_calendar 
WHERE created_by = :user 
ORDER BY duedate";

// TODO - take only events between valid range
$userdiary = datatable::query($userdiary_query, [
    "user" => auth::user_id()
]);

foreach ($userdiary["data"] as $key => $userevent) {

    $userevent_date = new DateTime($userevent["duedate"]);

    if (isset($data[date_format($userevent_date, "Y-m-d")])) {
        $data[date_format($userevent_date, "Y-m-d")]["userevents"][] = $userevent;
        $data[date_format($userevent_date, "Y-m-d")]["isbusy"] = true;
    }
}


// Get Birthdays

$birthday_query = "SELECT u.id as user_id, u.nickname as note, u.birthday FROM users as u WHERE birthday IS NOT NULL";

$birthdays = datatable::query($birthday_query);

if ($birthdays["success"] && $birthdays["count"] > 0) {

    foreach ($birthdays["data"] as $key => $value2) {

        $birthday_thisyear = new DateTime(date('Y') . "-" . (new DateTime($value2["birthday"]))->format('m-d'));
        //$birthday_nextyear = new DateTime(date('Y') . "-" . $bday->format('m-d'));
        if (isset($data[date_format($birthday_thisyear, "Y-m-d")])) {
            $data[date_format($birthday_thisyear, "Y-m-d")]["birthdays"][] = $value2;
            $data[date_format($birthday_thisyear, "Y-m-d")]["isbusy"] = true;
        }
    }
}

//ksort($data);
/*

$response["data"] = $responsedata;

//echo json_encode($response);

$calender_dates = [];

$startDate = new DateTime('2025-01-01');
$endDate = new DateTime('2025-12-31');

for ($date = $startDate; $date <= $endDate; $date->modify('+1 day')) {
    $calender_dates[] = [
        "date" => date_format($date, "d"),
        "day" => date_format($date, "D"),
        "month" => date_format($date, "M"),
        "year" => date_format($date, "Y"),
    ];
}


$calender = [];

// Loop through the next 12 months
for ($m = 0; $m < 12; $m++) {

    $startOfMonth = (new DateTime())->modify("first day of +$m month");
    $calender[$m]["year"] = $startOfMonth->format('Y');
    $calender[$m]["monthname"] = $startOfMonth->format('F');

    $dates = [];
    $date = $startOfMonth;

    for ($d = 0; $d < $startOfMonth->format('t'); $d++) {

        $calender[$m]["days"][] = [
            "date" => date_format($date, "d"),
            "day" => date_format($date, "D"),
            "month" => date_format($date, "M"),
            "isweekend" => in_array(date_format($date, "l"), ["Saturday", "Sunday"])
        ];
        $date = $date->modify("+1 days");
    }
}
*/

foreach ($data as $date => $d) {
    $d["key"] = $date;
    $response["data"][] = $d;
}

echo json_encode($response);
