<?php
include "../../src/config.php";

if (!auth::user()) {
    endrequest("You dont have access to this api");
}

if (!isset($_GET["title"])) {
    endrequest("Invalid Request");
}


$sql = "SELECT 
    LPAD(c.case_id,3,0) as case_id,
    c.case_title,
    c.case_file,
    c.state,
    c.state_note
FROM 
    cases as c
INNER JOIN case_states as s on c.state = s.state_id
having 
    c.case_title LIKE :title";

$data['title'] = "%" . $_GET['title'] . "%";

$response = datatable::query($sql, $data);

foreach ($response["data"] as $key => $value) {
    $response["data"][$key]["case_title"] = str_replace($_GET['title'], "<span class='text-searched'>" . $_GET['title'] . "</span>", $value["case_title"]);
}

echo json_encode($response);
