<?php
include "../../../src/config.php";

if (!isset($_GET["id"])) {
    endrequest("Invalid request");
} else {
    $letter = letters::get($_GET["id"]);
    if (!$letter) {
        endrequest("Invalid Letter ID");
    }
}

$response = [];

$events = [];

function datetime_to_date($t)
{
    return date("y M d", strtotime($t));
}

function datetime_to_time($t)
{
    return date("h:i A", strtotime($t));
}

function days_gone($t)
{
    return round((strtotime($t) - strtotime(letters::get($_GET["id"])["received"])) / 86400);
}

// Letter Signed date
$events[] = [
    "datetime" => date('Y-m-d H:i:s', strtotime($letter["date"])),
    "date" => datetime_to_date($letter["date"]),
    "time" => false,
    "content" => [
        "title" => "ලිපිය අත්සන් කල දිනය"
    ],
    "days" => days_gone($letter["date"]),
    "icon" => UI::icon("signature")
];

// Letter Recording
$events[] = [
    "datetime" => $letter["recorded_at"],
    "date" => datetime_to_date($letter["recorded_at"]),
    "time" => datetime_to_time($letter["recorded_at"]),
    "content" => [
        "title" => users::get($letter["user"])["shortname"] . " විසින් ලිපිය ලේඛනගත කිරීම"
    ],
    "days" => days_gone($letter["recorded_at"])
];

// Letter Received date
$events[] = [
    "datetime" => date('Y-m-d H:i:s', strtotime($letter["received"])),
    "date" => datetime_to_date($letter["received"]),
    "content" => [
        "title" => "ලිපිය ප්‍රධාන ලේකම් කාර්යාලය වෙත ලැබීම"
    ]
];

/*
if (days_gone(date("Y-m-d H:i:s")) > 14 && !in_array($letter["state"], [10, 11, 50])) {
    // 14 Days since latter received
    $date14 = date('Y-m-d H:i:s', strtotime('+14 day', strtotime($letter["received"])));
    $events[] = [
        "datetime" => $date14,
        "date" => datetime_to_date($date14),
        "warning" => true,
        "content" => [
            "title" => "ලිපිය ලැබී සති දෙකක් ගතවී ඇත"
        ],
        "days" => days_gone($date14)
    ];
}*/



// Letter Forwarded
/*
if ($letter["forwarded_at"]) {
    $events[] = [
        "datetime" => $letter["forwarded_at"],
        "date" => datetime_to_date($letter["forwarded_at"]),
        "time" => datetime_to_time($letter["forwarded_at"]),
        "content" => [
            "title" => users::get($letter["forwarded_by"])["shortname"] . " විසින් ලිපිය " . institutions::get($letter["forwarded"])["name"] . " වෙත යොමුකරන ලදි"
        ],
        "days" => days_gone($letter["forwarded_at"])
    ];
}
*/
$letter_forward = letters::forwardhistory($letter["id"]);

foreach ($letter_forward as $key => $value) {
    $events[] = [
        "type" => "forward",
        "datetime" => $value["created_at"],
        "date" => datetime_to_date($value["created_at"]),
        "time" => datetime_to_time($value["created_at"]),
        "content" => [
            "title" => users::get($value["created_by"])["shortname"] . " විසින් ලිපිය " . institutions::get($value["institution"])["name"] . " වෙත යොමුකරන ලදි"
        ],
        "days" => days_gone($value["created_at"]),
        "icon" => UI::icon("forward")
    ];
}

// Letter Assigned
if ($letter["assigned_at"]) {
    $events[] = [
        "datetime" => $letter["assigned_at"],
        "date" => datetime_to_date($letter["assigned_at"]),
        "time" => datetime_to_time($letter["assigned_at"]),
        "content" => [
            "title" => users::get($letter["assigned_by"])["shortname"] . " විසින් " . users::get($letter["assigned"])["shortname"] . " වෙත ලිපිය පවරන ලදි"
        ],
        "days" => days_gone($letter["assigned_at"])
    ];
}

$letter_assigned = letters::assignhistory($letter["id"]);

foreach ($letter_assigned as $key => $value) {
    $events[] = [
        "type" => "forward",
        "datetime" => $value["assigned_at"],
        "date" => datetime_to_date($value["assigned_at"]),
        "time" => datetime_to_time($value["assigned_at"]),
        "content" => [
            "title" => users::get($value["assigned_by"])["shortname"] . " විසින් " . users::get($value["assigned_to"])["shortname"] . " වෙත යොමුකරන ලදි"
        ],
        "days" => days_gone($value["assigned_at"]),
        "icon" => UI::icon("forward")
    ];
}


// Add user notes as events
/*
$usernotes = notes::byletter($_GET["id"]);
foreach ($usernotes as $key => $value) {
    $events[] = [
        "datetime" => $value["timestamp"],
        "date" => $value["date_text"],
        "time" => $value["time_text"],
        "note" => true,
        "id" => $value["id"],
        "editor" => ($value["user"] == auth::user_id()) ? true : false,
        "content" => [
            "title" => "Note by " . users::get($value["user"])["shortname"],
            "text" => $value["note"]
        ],
        "days" => days_gone($value["date"])
    ];
}*/

$response["events"] = [];

// Sort events 
usort($events, function ($a, $b) {
    $ad = new DateTime($a['datetime']);
    $bd = new DateTime($b['datetime']);

    if ($ad == $bd) {
        return 0;
    }

    return $ad < $bd ? -1 : 1;
});

$response["events"] = $events;

echo json_encode($response);
