<?php
include "../../../src/config.php";

if (!auth::user()) {
    endrequest("You dont have access to this api");
}

$response['input'] = $_GET;

$sql = "SELECT 
    l.*,
    DATE_FORMAT(l.date, '%y %b %d') as year,
    DATE_FORMAT(l.date, '%y %b %d') as date,
    DATE_FORMAT(l.timestamp, '%H:%i') as time,
    DATE_FORMAT(l.received, '%Y') as received_year,
    DATE_FORMAT(l.received, '%b') as received_month,
    DATE_FORMAT(l.received, '%d') as received_date,
    u.name as user_name, 
    u.id as user_id,
    a.shortname as assigned_shortname,
    a.code as assigned_code,
    IF(s.name IS NULL, l.sender2, s.name) as sender_name,
    f.codename as forwarded_codename,
    f.shortname as forwarded_shortname,
    src.name as source_name,
    states.name as state_name,
    l.state as state,
    DATEDIFF(CURDATE(),l.received) as datediff
FROM 
    mis_letters as l
INNER JOIN users as u on l.user = u.id
INNER JOIN mis_letter_sources as src on l.source = src.id
LEFT JOIN institutions as s on l.sender = s.id
LEFT JOIN institutions as f on l.forwarded = f.id
LEFT JOIN mis_letter_states as states on l.state = states.id
LEFT JOIN users as a on l.assigned = a.id
WHERE 
    l.state in (1,2,20,30) AND
    year(l.received) > 2023 
HAVING 
    datediff > :cutoff
ORDER BY datediff DESC
LIMIT 100";

$response['sql'] = $sql;


$response = datatable::query($sql, ["cutoff" => 14]);

foreach ($response["data"] as $key => $value) {
    $response["data"][$key]["notes"] = notes::byletter($value["id"]);
}

echo json_encode($response);
