<?php
include "../../../src/config.php";

if (!isset($_GET["user"])) {
    endrequest("Invalid request");
}

$query = "SELECT
    i.*, 
    u.name as user_name, 
    u.shortname as user_shortname, 
    u.designation,
    c.name,
    c.icon as icon,
    s.name as status_text,
    s.id as status_id
FROM 
    mis_inventory as i
JOIN mis_inventory_categories as c on i.category = c.id
JOIN mis_inventory_statuses as s on i.status = s.id
LEFT JOIN users as u on i.user = u.id
WHERE 
i.user = :user
ORDER BY i.status";

$response = datatable::query($query, ["user" => $_GET["user"]]);

foreach ($response["data"] as $key => $value) {
    $response["data"][$key]["status_icon"] = UI::icon("item-status-" . $response["data"][$key]["status_id"]);
}


echo json_encode($response);
