<?php
//configuration data
require "../../src/config.php";

page::set([
  "title" => "Inbox",
  "nav-parent" => "cases_all",
  "layout" => "admin",
  "size" => "box-full",
]);

page::header();
?>


<div class="card">
  <div class="card-body">
    <div id="case_list" class="datalist"></div>
  </div>
</div>


<script id="template" type="text/template">

  {{#data}}

    <div class="listitem bgs-state{{state}}" id="{{case_id}}">
      <div class="listitem-content py-2">
        <a href="/<?= SUBFOLDER ?>cases/summary?id={{case_id}}">
          <div class="row">

            <div class="col col-w6">
              {{informed_at}}
            </div>

            <div class="col ps-2">
              <div class="text-en">
                <span class="tag w-5">#{{case_id}}</span>
                <span class="tag-primary">{{case_file}}</span>
              </div>
              <div class="text-md text-strong py-1">{{case_title}}</div>
              <div class="text-xs text-muted">{{state_note}}</div>

            </div>
          </div>
        </a>
      </div>
    </div>

  {{/data}}
</script>

<script>
  var template = $("#template").html();
  var data = [];

  function show() {

    $("#case_list").html(UI_loading);
    var i = category();

    if (data[i]) {
      $("#case_list").html(Mustache.render(template, data[i]));
      filter();
    } else {
      $.getJSON(API + "cases/all.php", {
        state: i
      }, function(response) {
        data[i] = response;
        $("#case_list").html(Mustache.render(template, data[i]));
        filter();
      });
    }


  }

  $("#search_text").on("input", filter);
  $("#search_type").on("change", filter);

  function filter() {

    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");
    $.each(data[category()].data, function(key, value) {
      if (value[search_type].search(search_key) != -1 && (category() == 0 || value.state == category())) {
        $("#" + value.case_id).slideDown(200);
      } else {
        $("#" + value.case_id).slideUp(200);
      }
    });

  }

  function changecategory(category) {

    $(".pill").removeClass("active");
    $("#pill_" + category).addClass("active");
    show();
  }

  function category() {
    return parseInt($(".pill.active").data("category"));
  }

  changecategory(0);
</script>

<?php page::footer(); ?>