<?php
//configuration data
require "../../../../src/config.php";

page::access_control(["admin", "postmaster", "spectator", "manager"]);

page::set([
  "title" => "Chief Secretary's Office - Central Province - Daily Mail Summary",
  "nav-parent" => "mail_print_assigned",
  "layout" => "admin",
  "size" => "box-full",
  "appbar" => false,
  "permission" => ["admin", "post-master", "spectator"]
]);

page::header();
?>

<div class="printbox" id="printbox"></div>

<script id="letter_template" type="text/template">


  <div class="printbox-top">
   <div class="title">{{forwarded_name}} &nbsp;-&nbsp; {{input.year}}/{{input.month}}/{{input.day}} දින තැපෑල</div> 
  </div> 

  <div class="printbox-body">
  
    <div class="list text-sm">

        {{#data}}

            <div class="listitem" id="{{id}}">

                <div class="row listitem-content">

                    <div class="col cell col-w2 center">
                      <div class="text-lg text-strong center">{{index_no}}</div>
                    </div>

                    <div class="col cell col-w4 p-1 center">
                      <div class="text-md">#{{id}}</div>
                    </div>
                    
                    <div class="col cell col-w4 center">
                      <div class="text-xs">{{source_name}}</div>
                    </div>

                    <div class="col">
                      <div class="text-muted text-xs">{{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}}</div>
                      <div class="text">{{title}}</div>
                    </div>

                    <div class="col cell col-w4 center">
                      {{#assigned_code}}
                      <div class="assigned_text">1 / {{assigned_code}}</div>
                      {{/assigned_code}}
                    </div>

                    <div class="col col-w4 cell center">
                      <div class="mt-3">...............</div>
                    </div>

                </div>

            </div>

        {{/data}}

      </div>

    </div>

</script>

<script>
  var template = $("#letter_template").html();
  var data = [];

  $("#date_select").on("change", load);
  $("#forwarded_select, #date_select").on("change", load);

  function load() {

    $("#printbox").html(UI_loading);

    var date = $("#date_select").find(":selected");
    var forwarded = parseInt($("#forwarded_select").find(":selected").data("forwarded"));
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day") + "_" + forwarded;

    if (!data[key]) {
      $.getJSON(API + "/print/assigned.php", {
        year: date.data("year"),
        month: date.data("month"),
        day: date.data("day"),
        forwardedto: forwarded
      }, function(response) {
        data[key] = response;
        $("#printbox").html(Mustache.render(template, response));
      });
    } else {
      $("#printbox").html(Mustache.render(template, data[key]));
      filter();
    }

  }

  $(load);
</script>

<?php page::footer(); ?>