<?php
require "../../../src/config.php";

page::set([
    "title" => "Mail Stats - Assigned",
    "nav-parent" => "mail_stats",
    "page_id" => "mail_stats_assigned",
    "size" => "box-full",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

page::header();

?>

<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp; Assigned User
    </div>
    <div class="card-body">
        <div class="datalist">
            <?php foreach (analyst::letters_by_assigned() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">
                        <div class="col col-w6 pe-2">
                            <span class="tag-dcs-ad w-100"><?= $value["code"] ?></span>
                        </div>
                        <div class="col m-auto">
                            <span class="text"><?= $value["name"] ?></span>
                            <span class="text-sm text-primary ps-2">#<?= $value["shortname"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-muted text-strong"><?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?> %</span>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php page::footer(); ?>