<?php
require "../../../src/config.php";

page::set([
    "title" => "Reports - Forwarded",
    "nav-parent" => "reports_forwarding",
    "size" => "box-xl",
    "scripts" => ["chartjs"],
]);

page::header();

?>

<div class="card">

    <div class="card-top">
        <div class="title">මූලික පරීක්ෂණය සඳහා යොමුකල ආයතනය අනුව විනය කටයුතු ප්‍රමාණය</div>
    </div>

    <div class="card-body">

        <div class="datalist">
            <?php foreach (reports::count_by_institution() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col m-auto">
                            <span class="ps-2"><?= $value["ins_name"] ?></span>
                        </div>
                        <div class="col col-w4">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php page::footer(); ?>