<?php
require "../../src/config.php";

page::set([
    "title" => "All time Summary",
    "nav-parent" => "reports",
    "size" => "box-full",
    "scripts" => ["chartjs"]
]);

require FILE_ROOT . "src/layouts/admin/header.php";

//page::header();

$reports = [

    [
        "title" => "මූලික පරීක්ෂණය සඳහා යොමුකල ආයතනය අනුව විනය කටයුතු ප්‍රමාණය",
        "link" => "forwarded"
    ],
    [
        "title" => "Report 01",
        "link" => "forwarded"
    ],
    [
        "title" => "Report 02",
        "link" => "forwarded"
    ],
    [
        "title" => "Report 03",
        "link" => "forwarded"
    ],
    [
        "title" => "Report 04",
        "link" => "forwarded"
    ],
];

?>

<div class="card">
    <div class="card-body">

        <div class="datalist">
            <?php foreach ($reports as $key => $value) { ?>

                <div class="listitem bgs-state{{state}}">
                    <div class="listitem-content py-2">
                        <a href="<?= $value["link"] ?>">
                            <div class="row">
                                <div class="col col-w3 text-xl">
                                    <?= UI::icon("report") ?>
                                </div>

                                <div class="col ps-2">
                                    <div class="text-md py-1"><?= $value["title"] ?></div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>

            <?php } ?>
        </div>
    </div>
</div>

<?php page::footer(); ?>