<?php
require "../../src/config.php";

if (isset($_GET["id"])) {
    $case = cases::get($_GET["id"]);
    if (!$case) {
        error("Invalid Letter ID");
    }
} else {
    error("Invalid ID");
}

page::set([
    "title" => "Case Summary",
    "nav-parent" => "cases_all",
    "size" => "box-lg"
]);

if (page::submitted()) {

    $data = $_POST;

    if (isset($_GET['id']) && cases::get($_GET['id'])) {
        /* New Update */
        $data['case_id'] = $_GET['id'];
        $response = comments::create($data);
        if ($response["success"]) {
            header("Location: /" . SUBFOLDER . "cases/summary?id=" . $_GET['id']);
        } else {
            $data = $data;
        }
    } else if (isset($_GET['id']) && comments::get($_GET["id"])) {
        /* Update existing data */
        $response = comments::update($_GET['id'], $data);
        if ($response["success"]) {
            header("Location: /" . SUBFOLDER . "cases/summary?id=" . comments::get($_GET["case"])["case_id"]);
        }
        $data = $data;
    } else {
        error("Invalid letter ID");
    }
}

page::header();
?>

<div class="row">

</div>

<div class="card">

    <div class="card-body">

        <div class="datalist">

            <div class="listitem">
                <div class="row listitem-content">
                    <div class="col li-icon">
                        <?= UI::icon("file") ?>
                    </div>
                    <div class="col">
                        <div class="li-label">
                            ගොනුවේ අංකය
                        </div>
                        <div class="list-title">
                            <?= $case["case_file"] ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="listitem">
                <div class="row listitem-content">
                    <div class="col li-icon">
                        <?= UI::icon("info") ?>
                    </div>
                    <div class="col">
                        <div class="li-label">
                            විනය පරීක්ෂණය විස්තරය
                        </div>
                        <div class="list-title">
                            <?= $case["case_summary"] ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="listitem">
                <div class="row listitem-content">
                    <div class="col li-icon">
                        <?= UI::icon("institution") ?>
                    </div>
                    <div class="col">
                        <div class="li-label">
                            අදාලවන ආයතනය
                        </div>
                        <div class="list-title">
                            <?= institutions::get($case["relevant_ins"])["ins_name"] ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <a class="btn btn-primary text-xs float-end" href="../update?id=<?= $case["case_id"] ?>">
            Edit
        </a>

    </div>

</div>

<div class="card">
    <div class="card-body">

        <div class="datalist">

            <?php foreach (comments::bycase($case["case_id"]) as $comment) { ?>
                <div class="listitem bgs-state{{state}}" id="{{case_id}}">
                    <div class="listitem-content py-2">
                        <div class="row">

                            <div class="col col-w6">
                                <?= $comment["date_text"]  ?>
                            </div>

                            <div class="col ps-2">
                                <div class="text-muted text-xs"><?= $comment["user_name"] . " @" . $comment["date_text"]   ?></div>
                                <div class="text py-1"><?= $comment["text"]  ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

        <form method="post">

            <?php
            if (page::submitted()) {
                form::response_summary($response);
            }

            ?>

            <div class="form-group">
                <div class="input-group">
                    <textarea name="text" id="text" rows="4" class="form-control" aria-label="With textarea" required></textarea>
                </div>
            </div>

            <div class="row">
                <div class="col-6">
                    <button type="submit" class="btn btn-primary btn-block">Add Note</button>
                </div>
            </div>

        </form>
    </div>
</div>

<script>
    $.getJSON(API + "mail/letter/timeline.php", {
        id: <?= intval($_GET["id"]) ?>
    }, function(response) {
        render(response);
    });

    function render(render_data) {
        var template = $("#timeline_template").html();
        content = Mustache.render(template, render_data);
        $("#timeline").html(content);
    }
</script>

<?php page::footer(); ?>