<?php
require "../../src/config.php";

page::set([
    "title" => "Update Cases",
    "nav-parent" => "case_update",
    "layout" => "admin",
    "size" => "box-lg",
    "scripts" => ["pickday", "chosen"]
]);

page::access_control(["admin", "postmaster"]);

if (page::submitted()) {

    $input_data = $_POST;
    $input_data['informed_at'] = date('Y-m-d', strtotime($_POST['informed_at']));

    if (isset($_GET['id'])) {
        $case_id = $_GET['id'];
        $response = cases::update($_GET['id'], $input_data);
    } else {
        $response = cases::create($input_data);
        $case_id = $response["id"];
    }

    if ($response["success"]) {
        //header("location: ../summary?id=" . $case_id . "&new");
    }

    // Get updated data
    $data  = cases::get($case_id);
} else if (isset($_GET['id'])) {
    $data = cases::get($_GET['id']);
    if (!$data) {
        error("Invalid URL");
    }
} else {
    $data = cases::defaults();
}

page::header();

?>

<form method="post" class="card">

    <div class="card-body">

        <?php
        if (page::submitted()) {
            form::response_summary($response);
        }

        ?>

        <div class="form-section">

            <div class="form-section-title">මූලික තොරතුරු</div>


            <div class="form-group">
                <label for="id">කාරණය</label>
                <input type="text" class="form-control" name="case_title" id="case_title" value="<?= $data['case_title'] ?>" required>
            </div>

            <div class="form-group">
                <label for="case_summary">විස්තරය</label>
                <div class="input-group">
                    <textarea name="case_summary" id="case_summary" rows="5" class="form-control" aria-label="With textarea"><?= $data["case_summary"] ?></textarea>
                </div>
            </div>

            <div class="form-group">
                <label for="sender">අදාල ආයතනය</label>
                <select name="relevant_ins" id="relevant_ins" class=" ">
                    <option value="0">වෙනත් &nbsp; | &nbsp; other</option>
                    <?php
                    foreach (institutions::all() as $value) {
                        echo '<option value="' . $value['ins_id'] . '" ' . ($value["ins_id"] == $data["relevant_ins"] ? "selected" : "") . '>' . $value['ins_name'] . '</option>';
                    } ?>
                </select>
            </div>

            <div class="form-group">
                <label for="id">ගොනු අංකය</label>
                <input type="text" class="form-control" name="case_file" id="case_file" value="<?= $data['case_file'] ?>" required>
            </div>

        </div>


        <div class="form-section">

            <div class="form-section-title">පැමිණිල්ල දැනුම් දීම</div>

            <div class="row">

                <div class="col-4">
                    <div class="form-group">
                        <label for="date">දැනුම්දුන් දිනය</label>
                        <input type="text" class="form-control" name="informed_at" id="informed_at" value="<?= $data['informed_at'] ?>" readonly required>
                    </div>
                </div>


                <div class="col-8">


                    <div class="form-group">
                        <label for="id">දැනුම්දුන් පාර්ශවය</label>
                        <input type="text" class="form-control" name="informed_by" id="case_file" value="<?= $data['informed_by'] ?>" required>
                    </div>

                </div>

            </div>
        </div>

        <div class="form-section">

            <div class="form-section-title">වර්තමාන තත්වය</div>

            <div class="form-group">
                <label for="source">වර්තමාන තත්වය</label>
                <div class="radio-group">
                    <?php foreach (cases::states() as  $value) { ?>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="state" id="state_<?= $value["state_id"] ?>" value="<?= $value["state_id"] ?>" <?= $value["state_id"] == $data["state"] ? "checked" : "" ?> required>
                            <label class="form-check-label w-100" for="state_<?= $value["state_id"] ?>">
                                <?= $value["state_name"] ?>
                            </label>
                        </div>

                    <?php }  ?>
                </div>
            </div>


            <div class="form-group">
                <label for="case_summary">වර්තමාන තත්වය පිළිබඳ සටහන්</label>
                <div class="input-group">
                    <textarea name="state_note" id="state_note" rows="5" class="form-control" aria-label="With textarea"><?= $data["state_note"] ?></textarea>
                </div>
            </div>

        </div>
    </div>

    <div class="card-bottom">

        <div class="row">
            <div class="col-6">
                <button type="submit" class="btn btn-primary btn-block"><?= isset($_GET["id"]) ? "Update Letter" : "Add New Letter" ?></button>
            </div>
            <div class="col-6">
                <a href="../" class="btn btn-secondary btn-block">Back</a>
            </div>
        </div>

    </div>

</form>

<script>
    $("#relevant_ins").chosen({
        width: "100%"
    });

    var picker_received = new Pikaday({
        field: document.getElementById('informed_at'),
    });

    //$('input[name = "source"]').trigger("change");

    $('form').submit(function() {
        $(".card-bottom").html(UI_loading);
    });

    $(function() {
        $("#sender").trigger("change");
    });
</script>

<?php page::footer(); ?>