<script id="template" type="text/template">

    <div class="datalist">

        {{#data}}

        <div class="listitem" id="{{id}}">

            <div class="listitem-content">

                <div class="row">

                    <div class="col col-w4 center m-auto">
                        <div class="file-{{filetype}}">{{{icon}}}</div>
                    </div>

                    <div class="col m-auto">

                        <div class="text">
                            
                            <span class="text-w500">{{filename}}</span> 
                            <?php if (auth::isadmin()) { ?>
                                <a href="/<?= SUBFOLDER ?>modules/archive/update?id={{id}}" class="ms-3"><?= UI::icon("edit") ?></a>
                            <?php } ?>

                        </div>
                        {{#description}}
                        <div class="text-muted text-xs">{{description}}</div>
                        {{/description}}

                    </div>

                    <div class="col col-w4 center m-auto">
                        <span class="tag-primary w-100 text-xs">{{filetype}}</span> 
                    </div>
                    <div class="col col-w4 center m-auto">
                        <span class="text-muted text-xs mb-1">
                            {{filesize}} MB
                        </span>
                    </div>



                    <div class="col col-w8 center m-auto">
                        {{#file}}
                        <a class="pill text-w600" href="/<?= SUBFOLDER ?>modules/archive/download.php?id={{hash}}"><?= UI::icon("download") ?> <span class="text-xs mx-2">Download</span></a>
                        {{/file}}
                        {{^file}}
                        <div class="text-danger"><?= UI::icon("warning") ?></div>
                        {{/file}}
                    </div>
                    <?php if (auth::isadmin()) { ?>
                    <div class="col col-w4 center m-auto">
                        <div class="text-xs"><?= UI::icon("download") ?>{{downloads}}</div>
                    </div>
                    <?php } ?>
 
                </div>

            </div>
                
        </div>
        
        {{/data}}

    </div>
    
</script>