<?php
require "../../../src/config.php";

//check permissions
if (!auth::isadmin()) {
    router::redirect("home");
}

if (page::submitted()) {

    $file = $_POST;
    $file["visible"] = isset($_POST["visible"]) ? 1 : 0;

    if (isset($_FILES["file"]) && file_exists($_FILES['file']['tmp_name'])) {
        $file["filetype"] = pathinfo($_FILES["file"]["name"])["extension"];
        $file["filesize"] = $_FILES["file"]["size"];
        $file["hash"] = archive::filehash();
    }

    if (isset($_GET['id'])) {
        $response = archive::update($_GET['id'], $file);
    } else {
        $response = archive::create($file);
    }

    if ($response["success"] && file_exists($_FILES['file']['tmp_name'])) {
        $target_file = FILE_ROOT . "modules/archive/files/" . $file["hash"] . "." . $file["filetype"];
        $upload = move_uploaded_file($_FILES["file"]["tmp_name"], $target_file);
    }
} else if (isset($_GET['id'])) {
    $file = archive::get($_GET['id']);
    if (!$file) {
        error("Invalid URL");
    }
} else {
    $file = archive::defaults();
}


page::set([
    "title" => "Update File",
    "nav-parent" => "admin_files",
    "layout" => "admin",
    "size" => "box-lg",
    "scripts" => ["pickday"]
]);

page::header();

?>
<link rel="stylesheet" type="text/css" href="/<?= SUBFOLDER ?>src/styles/pickday.css">

<form method="post" class="card" enctype="multipart/form-data">

    <div class="card-top">
        <div class="title"> File Update</div>
    </div>

    <div class="card-body">

        <?php if (page::submitted()) {
            form::response_summary($response);
        } ?>

        <div class="form-content">

            <div class="form-group">
                <label for="number">Name</label>
                <input type="text" class="form-control" name="filename" id="filename" value="<?= $file['filename'] ?>">
            </div>

            <div class="form-group">
                <label for="description">Description</label>
                <textarea rows="3" type="text" class="form-control" name="description" id="description"><?= $file['description'] ?></textarea>
            </div>

            <div class="row">

                <div class="col">
                    <div class="form-group">
                        <label for="file">
                            File
                            <?php if (isset($_GET['id']) && file_exists(FILE_ROOT . "src/archive/" . $_GET['id'] . ".pdf")) {
                                echo "<span class='text-success ms-3'>" . $_GET['id']  . ".pdf " . UI::icon("verified") . "</span>";
                            } else {
                                echo "<span class='text-danger'>" . UI::icon("warning") . "</span>";
                            } ?>
                        </label>
                        <input type="file" class="form-control" name="file" id="file">
                    </div>
                </div>

                <div class="col-4">
                    <div class="form-group">
                        <label for="category">Category</label>
                        <div class="input-group">
                            <select name="category" id="category" class="form-control">
                                <?php foreach (archive::categories() as $value) {
                                    echo '<option value="' . $value['id'] . '" ' . ($value["id"] == $file["category"] ? "selected" : "") . '>' . $value['name'] . '</option>';
                                }  ?>
                            </select>
                        </div>
                    </div>
                </div>

            </div>

        </div>

        <div class="form-group">
            <div class="row">
                <div class="col col-w4">
                    <input type="checkbox" class="switch" id="visible" name="visible" <?= ($file['visible']) ? "checked" : "" ?>>
                </div>
                <div class="col">
                    <label class="form-check-label w-100" for="visible">
                        <span class=" ">Visible</span>
                    </label>
                </div>
            </div>
        </div>

    </div>

    <div class="card-bottom">

        <div class="row">
            <div class="col-6">
                <button type="submit" class="btn btn-primary btn-block">Update</button>
            </div>
            <div class="col-6">
                <a href="../" class="btn btn-secondary btn-block">Back</a>
            </div>
        </div>

    </div>

</form>

<script>
    var picker = new Pikaday({
        field: document.getElementById('released'),
    });

    $('form').submit(function() {
        $(".card-bottom").html(UI_loading);
    });
</script>

<?php page::footer(); ?>