<?php
//configuration data
require "../../../src/config.php";

page::set([
  "title" => "Letters",
  "nav-parent" => "mail_all",
  "layout" => "admin",
  "size" => "box-full",
]);

page::header();
?>

<div class="card">
  <div class="card-body">
    <div id="mail_list"></div>
  </div>
</div>


<script id="letter_template" type="text/template">

  <div class="datalist text-sm">

      {{#data}}

          <div class="listitem" id="{{id}}">

              <div class="row listitem-content">

                  <div class="col col-w5 m-auto center px-2">
                    
                    <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}">
                      <div class="tag-id w-100">{{id}}</div>  
                    </a>

                  </div>

                  <div class="col col-w4 m-auto center px-2">
                    <div class="text-xs">
                      {{source_name}}
                    </div>
                  </div>

                  <div class="col">
                    <div class="text-xs text-muted">
                      <span class="{{#is_knownsender}} text-success {{/is_knownsender}} ">
                        {{sender_name}}
                      </span> 
                      &nbsp; | &nbsp;   {{date}} &nbsp; | &nbsp; {{number}}</div>
                    <div class="text">{{title}}</div>
                  </div>

                  <div class="col col-w3 m-auto px-1">
                  {{#has_csorder}}
                  <div class="tag-dark w-100">cs</div> 
                  {{/has_csorder}}
                  </div>

                  <div class="col col-w5 m-auto">

                    <div class="tag-{{forwarded_codename}} w-100 text">
                      {{forwarded_shortname}}
                    </div> 

                  </div>

                  <?php if (auth::ispostmaster()) { ?>
                    <div class="col col-w2 m-auto center text-sm">
                      <a href="/<?= SUBFOLDER ?>modules/mail/update?id={{id}}">
                        <?= UI::icon("edit") ?>
                      </a>
                    </div>
                  <?php } ?> 

                  <div class="col col-w5 px-1 m-auto">

                  {{#assigned_code}}
                  <div class="tag-{{forwarded_codename}} w-100 text">
                    {{assigned_code}}
                  </div> 
                  {{/assigned_code}}
                </div>


                  <?php if (auth::ispostmaster()) { ?>
                    <div class="col col-w2 m-auto center text-sm">
                      <a href="/<?= SUBFOLDER ?>modules/mail/assign?id={{id}}">
                        <?= UI::icon("edit") ?>
                      </a>
                    </div>
                  <?php } ?> 

              </div>

          </div>

      {{/data}}

    </div>

</script>



<script>
  var template = $("#letter_template").html();
  var data = [];

  $("#date_select").on("change", load);
  $("#search_text").on("input", filter);
  $("#forwarded_select, #date_select, #search_type").on("change", filter);

  function load() {

    $("#mail_list").html(UI_loading);

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");
    if (!data[key]) {
      $.getJSON(API + "letters.php", {
        year: date.data("year"),
        month: date.data("month"),
        day: date.data("day"),
      }, function(response) {
        data[key] = response;
        $("#mail_list").html(Mustache.render(template, response));
        filter();
      });
    } else {
      $("#mail_list").html(Mustache.render(template, data[key]));
      filter();
    }

  }

  function filter() {

    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");

    var date = $("#date_select").find(":selected");
    var forwarded = $("#forwarded_select").find(":selected").data("forwarded");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");

    $.each(data[key]["data"], function(key, value) {
      console.log(value.forwarded + " , " + forwarded);
      if (forwarded == value.forwarded) {
        console.log(value.forwarded + " == " + forwarded);
      }
      if (value[search_type].search(search_key) != -1 && (forwarded == "all" || value.forwarded == parseInt(forwarded))) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }


  $(function() {
    load();
  });
</script>

<?php page::footer(); ?>