<?php
//configuration data
require "../../../src/config.php";

page::set([
  "title" => "Letters",
  "nav-parent" => "progress_delayed",
  "layout" => "admin",
  "size" => "box-full",
  "scripts" => ["chartjs"]
]);

page::header();
?>

<div class="card">

  <div class="card-body">

    <div class="datalist">

      <div class="listitem">
        <div class="row listitem-content">
          <div class="col-w6 m-auto">
            <span class="col-w5 w-100">

            </span>
          </div>
          <div class="col d-none d-lg-block m-auto">

          </div>
          <div class="col col-w5 center">
            <span class="tag-delayed bg-warning">+7</span>
          </div>
          <div class="col col-w5 center">
            <span class="tag-delayed">+14</span>
          </div>
          <div class="col col-w5 center">
            <span class="tag-delayed">+21</span>
          </div>
          <div class="col col-w5 center">
            <span class="tag-delayed">+30</span>
          </div>
          <div class="col col-w5 center">
            <span class="tag-delayed">+60</span>
          </div>
        </div>
      </div>

      <?php foreach (stats::delayed_letters_all() as $value) { ?>
        <div class="listitem listitem-important">
          <div class="row listitem-content">
            <div class="col-w6 m-auto">


            </div>
            <div class="col m-auto d-none d-lg-block ">
              <div class="text-strong text-md">ප්‍රධාන ලේකම් කාර්යාලය</div>
            </div>
            <div class="col col-w5 center">
              <span class="text-lg text-strong">
                <?= $value["1week"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-lg text-strong">
                <?= $value["2weeks"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-lg text-strong">
                <?= $value["3weeks"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-lg text-strong">
                <?= $value["month"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-lg text-strong">
                <?= $value["2months"] ?>
              </span>
            </div>
          </div>
        </div>
      <?php } ?>

      <?php foreach (stats::delayed_letters_by_division() as $value) { ?>
        <div class="listitem">
          <div class="row listitem-content">
            <div class="col-w6 m-auto">
              <span class="tag-<?= $value["codename"] ?> col-w5 w-100">
                <?= $value["shortname"] ?>
              </span>
            </div>
            <div class="col d-none d-lg-block m-auto">
              <?= $value["name"] ?>
            </div>
            <div class="col col-w5 center">
              <span class="text-md">
                <?= $value["1week"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-md">
                <?= $value["2weeks"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-md">
                <?= $value["3weeks"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-md">
                <?= $value["month"] ?>
              </span>
            </div>
            <div class="col col-w5 center">
              <span class="text-md">
                <?= $value["2months"] ?>
              </span>
            </div>
          </div>
        </div>
      <?php } ?>


    </div>

  </div>

</div>
<div class="card">
  <div class="card-body">
    <div id="mail_list" class="mt-4"></div>
  </div>
</div>


<script id="letter_template" type="text/template">

  <div class="datalist text-sm">

      {{#data}}

          <div class="listitem bg-sstate{{state}}" id="{{id}}">

              <div class="row listitem-content">

                <div class="col col-w5 center">
                  <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}">
                    <div class="tag-id mt-1 w-100">{{id}}</div> 
                  </a>
                </div>

                <div class="col col-w5 center">
                    <div class="text">{{received_month}} {{received_date}}</div>
                    <div class="tag-delayed mt-1">+{{datediff}}</div>
                </div>

                <div class="col">
                  <div class="text-xs">
                    <span class="{{#is_knownsender}} text-success {{/is_knownsender}} ">{{sender_name}}</span> 
                    &nbsp; | &nbsp; 
                    {{date}} &nbsp; | &nbsp; 
                    {{number}}</div>
                  <div class="text-strong text-md">{{title}}</div>
                  <div class="text-danger text-xs">{{state_name}}</div>
                  <div class="mt-1">
                    {{#notes}}
                    <div class="row mt-1">
                      <div class="col col-w1">
                        <div class="text-muted text-xs float-end text-primary"><?= UI::icon("note") ?></div>
                      </div>                     
                      <div class="col">
                        <div class="text-xs">
                          {{note}}
                          </div>
                      </div>
                    </div>
                    {{/notes}}
                  </div>

                </div>

                <div class="col col-w3 m-auto px-1">
                  {{#has_csorder}}
                  <div class="tag-dark w-100">cs</div> 
                  {{/has_csorder}}
                </div>

                <div class="col col-w6 p-2">

                  <div class="tag-{{forwarded_codename}} w-100 text">
                    <span class="text-sm">{{forwarded_shortname}}</span>
                  </div> 
                  {{#assigned_code}}
                  <div class="tag-{{forwarded_codename}} w-100 text mt-1">
                      <div class="text-sm">{{assigned_shortname}}</div> 
                  </div> 
                  {{/assigned_code}}
                </div>

              </div>

          </div>

      {{/data}}

    </div>

</script>

<script>
  var template = $("#letter_template").html();
  var data = [];


  $("#date_select").on("change", load);
  $("#search_text").on("input", filter);
  $("#forwarded_select, #date_select, #search_type").on("change", filter);

  function load() {

    $("#mail_list").html(UI_loading);

    $.getJSON(API + "mail/progress/delayed.php", function(response) {
      data = response;
      $("#mail_list").html(Mustache.render(template, response));
      filter();
    });
  }

  function changecategory(category) {

    $(".pill").removeClass("active");
    $("#pill_" + category).addClass("active");
    filter();

  }

  function filter() {


    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");

    var forwarded = $(".pill.active").data("category");

    $.each(data["data"], function(key, value) {
      if (value[search_type].search(search_key) != -1 && (forwarded == 0 || value.forwarded == parseInt(forwarded))) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }

  $(function() {
    load();
  });
</script>

<?php page::footer(); ?>