<?php
//configuration data
require "../../../src/config.php";

page::access_control(["admin", "postmaster"]);

page::set([
  "title" => "Forward and Assign",
  "nav-parent" => "mail_forward",
  "size" => "box-full"
]);

if (page::submitted()) {

  $data = $_POST;
  display($data);

  foreach ($data["forwarded"] as $letter_id => $forwarded_to) {
    $response = letters::forward(intval($letter_id), $forwarded_to);
  }

  foreach ($data["assigned"] as $letter_id => $assigned_to) {
    $response = letters::assign(intval($letter_id), $assigned_to);
  }
}

page::header();
?>


<form method="post" class="card">

  <div class="card-body">

    <div id="mail_list"></div>

  </div>


  <div class="card-bottom">

    <div class="row">
      <div class="col-6">
        <button type="submit" class="btn btn-primary btn-block">Update</button>
      </div>
      <div class="col-6">
        <a href="../" class="btn btn-secondary btn-block">Back</a>
      </div>
    </div>

  </div>

</form>


<script id="letter_template" type="text/template">

  <div class="datalist text-sm">

      {{#data}}

          <div class="listitem" id="{{id}}">

              <div class="row listitem-content bg-{{assigned_shortname}}">

                  <div class="col col-w6 m-auto center px-2">
                    <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}">
                      <div class="tag-id w-100">{{id}}</div>  
                    </a>
                  </div>

                  <div class="col m-auto">
                    <div class="text-muted text-xs">{{source_name}}&nbsp;|&nbsp;{{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}} </div>
                    <div class="text-strong text-md">{{title}}</div>
                  </div>

                  <div class="col col-w8 m-auto">

                  <div class="form-group">
                      <select name="forwarded[{{id}}]" id="forwarded-{{id}}" class="form-control a">
                          <?php foreach (institutions::forwardlist() as $value) {
                            echo '<option value="' . $value['id'] . '">' . $value['shortname'] . '</option>';
                          } ?>
                      </select>
                    </div>
                  </div>

                  <div class="col col-w10 m-auto">

                    <div class="form-group">
                      <select name="assigned[{{id}}]" id="assigned-{{id}}" class="form-control">
                        <option value="0"> None </option>
                          <?php foreach (users::subject_officers(users::get(auth::user_id())["institution"]) as $value) {
                            echo '<option value="' . $value['id'] . '">' . $value['code'] . '  &nbsp; ' . $value['shortname'] . '</option>';
                          } ?>
                      </select>
                    </div>
                  </div>

              </div>

          </div>

      {{/data}}

    </div>

</script>



<script>
  var template = $("#letter_template").html();
  var data = [];

  $("#date_select").on("change", load);
  $("#search_text").on("input", filter);
  $("#search_type").on("change", filter);

  function load() {

    $("#mail_list").html(UI_loading);

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");

    if (!data[key]) {
      $.getJSON(API + "mail/received.php", {
        year: date.data("year"),
        month: date.data("month"),
        day: date.data("day"),
      }, function(response) {
        data[key] = response;
        render_list(response);
        filter();
      });
    } else {
      render_list(data[key]);
      filter();
    }

  }

  function filter() {

    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");

    console.log(key);
    $.each(data[key]["data"], function(key, value) {
      if (value[search_type].search(search_key) != -1) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }

  function updateform(data) {
    data.forEach(element => {
      $("#assigned-" + element.id).val(element.assigned);
      $("#forwarded-" + element.id).val(element.forwarded);
    });
    //$('.form-control').css('background-color', '#D3D3D3');

  }

  function render_list(input_data) {

    $("#mail_list").html(Mustache.render(template, input_data));

    input_data.data.forEach(element => {

      $("#assigned-" + element.id).val(element.assigned);
      $("#forwarded-" + element.id).val(element.forwarded);

      $("#forwarded-" + element.id).on("change", function() {
        {
          if ($(this).val() != element.forwarded) {
            $(this).addClass("changed-input");
            $("#assigned-" + element.id).hide();

          } else {
            $(this).removeClass("changed-input");
            $("#assigned-" + element.id).show();
          }
        }
      });;

    });


  }

  $(function() {
    load();
  });


  $('form').submit(function() {
    $(".card-bottom").html(UI_loading);
  });
</script>

<?php page::footer(); ?>