<?php
//configuration data
require "../../../src/config.php";

page::access_control(["admin", "postmaster", "spectator", "manager"]);

page::set([
  "title" => "Chief Secretary's Office - Central Province - Daily Mail Summary",
  "nav-parent" => "mail_print",
  "layout" => "admin",
  "size" => "box-full",
  "appbar" => false,
  "permission" => ["admin", "post-master", "spectator"]
]);

page::header();
?>
<div class="printbox">
  <div class="printbox-top">
    <div class="title">මධ්‍යම පළාත් ප්‍රධාන ලේකම් කාර්යාලය</div>
    <div id="print_heading_content"></div>
  </div>
  <div class="printbox-body">
    <div id="mail_list"></div>
  </div>
</div>

<script id="print_heading" type="text/template">

  <div class="text-sm">{{date}}</div>
  <div class="text-sm">{{forwarded_name}}</div>

</script>

<script id="letter_template" type="text/template">

  <div class="list text-sm">

      {{#data}}

          <div class="listitem" id="{{id}}">

              <div class="row listitem-content">

                  <div class="col col-w4 m-auto center pe-2">
                    <div class="text-md text-strong">{{id}}</div>
                  </div>

                  <div class="col">
                    <div class="text-muted text-xs">{{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}}</div>
                    <div class="text-primary">{{title}}</div>
                  </div>

                  <div class="col col-w4" hidden>
                    <div class="forwarded_text">{{forwarded_shortname}}</div> 
                  </div>

                  <div class="col col-w2">
                    {{#assigned_code}}
                    <div class="assigned_text">{{assigned_code}}</div>
                    {{/assigned_code}}
                  </div>

                  <div class="col col-w4">

                  </div>

              </div>

          </div>

      {{/data}}

    </div>

</script>

<script>
  var template = $("#letter_template").html();
  var data = [];

  $("#date_select").on("change", load);
  $("#forwarded_select, #date_select").on("change", function() {
    filter();
    updateheader();
  });

  function load() {

    $("#mail_list").html(UI_loading);

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");
    if (!data[key]) {
      $.getJSON(API + "printdata.php", {
        year: date.data("year"),
        month: date.data("month"),
        day: date.data("day"),
      }, function(response) {
        data[key] = response;
        $("#mail_list").html(Mustache.render(template, response));
        filter();
      });
    } else {
      $("#mail_list").html(Mustache.render(template, data[key]));
      filter();
    }

  }

  function filter() {

    var date = $("#date_select").find(":selected");
    var forwarded = $("#forwarded_select").find(":selected").data("forwarded");
    var key = date.data("year") + "_" + date.data("month") + "_" + date.data("day");

    $.each(data[key]["data"], function(key, value) {

      if (value.forwarded == parseInt(forwarded)) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }

  function updateheader() {

    var date = $("#date_select").find(":selected");

    var head_data = {
      "date": date.data("year") + "-" + date.data("month") + "-" + date.data("day"),
      "forwarded_name": $("#forwarded_select").find(":selected").data("forwarded_name")
    }
    var print_heading_template = $("#print_heading").html();

    $("#print_heading_content").html(Mustache.render(print_heading_template, head_data));

  }

  $(function() {
    load();
    updateheader();
  });
</script>

<?php page::footer(); ?>