<script id="template" type="text/template">

    <div class="card">
    {{not-assigned}}
    </div>

    <div class="row">

        <div class="col-lg-6">
            <div class="row">
                <div class="col">
                    <div class="statcard card">
                        <div class="title">ලැබුණු ලිපි</div>
                        <div class="number">{{received_count}}</div>
                    </div>
                </div>
                <div class="col">
                    <div class="statcard card">
                        <div class="title text-sm">තොරතුරු ඇතුලත් කිරීමේ ප්‍රගතිය</div>
                        <div class="number">{{updated_percentage}} <span class="text-xs">%</span> </div>
                    </div>
                </div>
                <div class="col">
                    <div class="statcard card">
                        <div class="title">වැඩ අවසන් කිරීම</div>
                        <div class="number">{{completed_percentage}}<span class="text-xs">%</span></div>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <div class="card">
        
        <div class="card-body">

        <div class="datalist">
        {{#summary}}

            <div class="listitem" id="{{id}}">

                    <div class="row listitem-content">

                        <div class="col m-auto">

                            <div class="text">
                                <span class="progress-text-{{id}}">{{name}}</span>
                            </div>

                        </div>

                        <div class="col col-w6 m-auto text-strong text-lg center">
                            <span class="text">{{count}}</span>
                        </div>

                        <div class="col-lg-6 m-auto">

                            <div class="row m-auto">

                                <div class="col progress m-auto">
                                    <div class="progress-bar" role="progressbar" data-value="{{percentage}}" aria-valuenow="" style="width: 0%" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>

                                <div class="col col-w6 m-auto text-strong center">
                                    <div class="text-success"> <span class="text-lg">{{percentage}}</span> <span class="text-xs">%</span> </div>
                                </div>

                            </div>
                            
                        </div>

                    </div>

            </div>

        {{/summary}}
        </div>

        </div>
        
    </div>

    <div class="card">

        <div class="card-body">

            <div class="row listitem-content text-xs">

                <div class="row text-muted">
                    <div class="col-lg-6">
                        <div class="row">

                            <div class="col col-w5">

                            </div>
                            <div class="col">
                                <div class="text">නිලධාරියා</div>
                            </div>
                            <div class="col col-w6 m-auto px-2">
                                <div class="center">විෂය</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">

                        <div class="row">

                            <div class="col col-w6 center">
                                <span class="text">ලැබුණු ලිපි</span>
                            </div>

                            <div class="col col-w5 center">
                                <span class="text">නොදනී</span>
                            </div>

                            <div class="col col-w5 center">
                                <span class="text">ක්‍රියා කරන</span>
                            </div>

                            <div class="col col-w5 center">
                                <span class="text">වැඩ අවසන්</span>
                            </div>

                            <div class="col">
                            </div>

                            <div class="col col-w6 center">
                                <span class="text">ප්‍රගතිය</span>
                            </div>

                        </div>
                    </div>
                </div>

            </div>

            <div class="datalist">

                {{#officers.data}}

                    <div class="listitem" id="{{id}}">

                        <a href="/<?= SUBFOLDER ?>user/profile?id={{id}}">

                            <div class="row listitem-content">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="row">

                                            <div class="col col-w4">
                                                <div class="avatar-sm center">
                                                    <img class="" src="/<?= SUBFOLDER ?>src/images/users/{{id}}.png" onerror="this.src='/<?= SUBFOLDER ?>src/images/users/default.png';">
                                                </div>
                                            </div>
                                            <div class="col m-auto">

                                                <div class="text">
                                                    <span class="">{{name}}</span>
                                                    <span class="text-primary text-strong text-xs ms-2">#{{shortname}}</span>
                                                </div>
                                                <div class="text-muted text-xs">{{designation}}</div>

                                            </div>
                                            <div class="col col-w6 m-auto px-2">
                                                {{#is_active}}
                                                <div class="tag-{{institution_codename}} w-100 text text-strong">
                                                    {{code}}
                                                </div>
                                                {{/is_active}}
                                                {{^is_active}}
                                                <div class="tag-muted w-100 text-sm text-strong">
                                                    {{user_state_name}}
                                                </div>
                                                {{/is_active}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 m-auto">

                                        <div class="row m-auto">
                                            <div class="col col-w6 m-auto text-strong center">
                                                <span class="text text-md">{{count}}</span>
                                            </div>

                                            <div class="col col-w5 m-auto text-strong center">
                                                <span class="text-danger text-md">{{notupdated}}</span>
                                            </div>

                                            <div class="col col-w5 m-auto text-strong center">
                                                <span class="text-warning text-md">{{pending}}</span>
                                            </div>

                                            <div class="col col-w5 m-auto text-strong center">
                                                <span class="text-success text-md">{{completed}}</span>
                                            </div>

                                            <div class="col progress m-auto">
                                                <div class="progress-bar" role="progressbar" data-value="{{progress}}" aria-valuenow="" style="width: 0%" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>

                                            <div class="col col-w6 m-auto text-strong center">
                                                <div class="text-success"> <span class="text-lg">{{progress}}</span> <span class="text-xs">%</span> </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>

                        </a>

                    </div>

                {{/officers.data}}

            </div>

        </div>
    </div>
</script>