<?php
require "../../../src/config.php";

page::set([
  "title" => "Mail Search",
  "nav-parent" => "mail_search"
]);

page::header();
?>


<div class="card">
  <div class="card-body">
    <div id="results"></div>
  </div>
</div>

<script id="letter_template" type="text/template">


  {{#count}}

    <div id="search_bodytext" class="text center text-strong text-primary py-3">
      {{count}} Results
    </div>

    <div class="datalist">
      {{#data}}
        <div class="listitem">

          <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}" target="_blank">
            <div class="listitem-content">

              <div class="row">

                <div class="col col-w6 p-2">
                  <div class="tag-id w-100">{{id}}</div>
                </div>

                <div class="col col-w6 p-2">
                  <div class="center">{{received_text}}</div>
                </div>

                <div class="col-lg">
                  <div class="text-primary text-xs">{{{sender_name}}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{{number}}} </div>
                  <div class="text-strong">{{{title}}}</div>
                  <div class="text-xs progress-text-{{state}}">{{state_name}}</div>
                </div>

                <div class="col-lg-3">

                  <div class="row">
                    <div class="col">

                    </div>
                    <div class="col col-w3 m-auto px-1">
                      {{#cs}}
                        <div class="tag-dark text-xs w-100">CS</div>
                      {{/cs}}
                    </div>
                    <div class="col col-w6 m-auto px-1">
                      <div class="tag-{{forwarded_codename}} w-100 text-xs ">{{forwarded_shortname}}</div>
                    </div>
                    <div class="col col-w6 m-auto px-1">
                      {{#assigned_code}}
                        <div class="tag-{{forwarded_codename}} w-100">
                          {{assigned_shortname}}
                        </div>
                      {{/assigned_code}}
                    </div>

                  </div>
                </div>

              </div>

            </div>
          </a>

        </div>
      {{/data}}
    </div>
  {{/count}}

  {{^count}}
    <div class="center pt-3">
      <div id="search_bodytext" class="text center text-strong text-primary">
        {{#search_term}}
          Nothing Found for "{{search_term}}"
        {{/search_term}}
        {{^search_term}}
          Start typing at least 3 characters to see results!
        {{/search_term}}
      </div>
      <img class="col-w12 m-2" src="/<?= SUBFOLDER ?>src/images/search.png" alt="">
    </div>
  {{/count}}
  </div>

</script>

<script>
  $("#search_title, #search_sender").on("input", search);
  $("#search_cs").on("change", search);

  var searchlog = [];

  function search() {

    let timestamp = Date.now();
    var search_title = $("#search_title").val();
    var search_sender = $("#search_sender").val();

    searchlog.push({
      "timestamp": timestamp,
      "title": search_title,
      "sender": search_sender
    });

    if (search_title.length < 3 && search_sender.length < 3) {
      render({
        "message": "Enter atleast 3 characters to search"
      });

      $("#search_title,#search_sender").removeClass("inputstate-valid").addClass("inputstate-invalid");

    } else if (search_title.length > 2 || search_sender.length > 2) {

      $("#search_title,#search_sender").removeClass("inputstate-invalid").addClass("inputstate-valid");

      setTimeout(function() {

        let lastsearch = searchlog.slice(-1)[0];

        if (lastsearch.timestamp == timestamp) {

          $("#results").html(UI_loading);

          $.getJSON(API + "mail/search.php", {
            title: lastsearch.title,
            sender: lastsearch.sender
          }, render);

        } else {
          console.log("Obsolete Search Discarded");
          return;
        }
      }, 1500);

    }

  }

  function getsearchresult(t) {

    let lastsearch = searchlog.slice(-1)[0];

    if (lastsearch.timestamp == t) {
      $("#results").html(UI_loading);
      $.getJSON(API + "mail/search.php", {
        title: lastsearch.title,
        sender: lastsearch.sender
      }, render);

    } else {
      return;
    }

  }

  function render(render_data) {
    var template = $("#letter_template").html();
    content = Mustache.render(template, render_data);
    $("#results").html(content);
  }

  search();

  $("#gotoletter").on("click", function() {
    var id = $("#gotoletter_id").val();
    window.location.replace(HOME + "mail/letters/summary?id=" + id);
  });
</script>

<?php page::footer(); ?>