<?php
require "../../../../src/config.php";

page::set([
    "title" => "Mail Stats - Forwarded",
    "page_id" => "mail_stats_forwarding",
    "nav-parent" => "mail_stats",
    "size" => "box-full",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

page::header();

?>

<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp;Forwarded Division
    </div>
    <div class="card-body">

        <div class="datalist">
            <?php foreach (analyst::letters_by_forwarded() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col-4 m-auto">
                            <span class="tag-<?= $value["codename"] ?> col-w6 w-100"><?= $value["shortname"] ?></span>
                            <span class="ps-2"><?= $value["name"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>
                        <div class="col progress">
                            <div class="progress-bar" role="progressbar" style="width: <?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>%" aria-valuenow="<?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>

                        <div class="col col-w4 right">
                            <span class="text-muted text-strong"><?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?> %</span>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php page::footer(); ?>