<?php
require "../../../src/config.php";

page::set([
    "title" => "All time Summary",
    "nav-parent" => "mail_stats",
    "size" => "box-full",
    "scripts" => ["chartjs"]
]);

require FILE_ROOT . "src/layouts/admin/header.php";

//page::header();

?>
<div class="statspage-container h-100">

    <div class="title">
        <?= UI::icon("summary") ?> &nbsp; Received Month
    </div>
    <canvas id="myChart"></canvas>
    <div class="body">
        <canvas id="myChart"></canvas>

        <div class="datalist">
            <?php foreach (analyst::monthly_count() as $value) { ?>

                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col">
                            <?= $value["y"] . " &nbsp; " . $value["m"]; ?>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels">
</script>
<script>
    Chart.defaults.font.family = 'Yaldevi';
    Chart.defaults.font.size = 16;

    const ctx = document.getElementById('myChart');
    Chart.register(ChartDataLabels);
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul"],
            datasets: [{
                label: 'Letters',
                data: [65, 59, 80, 81, 56, 55, 40, 65, 59, 80, 81, 56, 55, 40],
                backgroundColor: [
                    'rgba(21, 143, 143,0.9)'
                ],
                borderRadius: 5
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    max: 200,
                }
            },
            plugins: {
                datalabels: {
                    // Position of the labels 
                    // (start, end, center, etc.)
                    anchor: 'end',
                    // Alignment of the labels 
                    // (start, end, center, etc.)
                    align: 'end',
                    font: {
                        weight: 'bold',
                        size: 24
                    },
                    formatter: function(value, context) {
                        // Display the actual data value
                        return value;
                    }
                },
                legend: {
                    display: false
                },
                tooltip: {
                    enabled: false
                }
            }
        }
    });
</script>

<?php page::footer(); ?>