<?php
require "../../../../src/config.php";

page::set([
    "title" => "Mail Stats - Recieved",
    "page_id" => "mail_stats_received",
    "nav-parent" => "mail_stats",
    "size" => "box-full",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

page::header();

?>

<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> ලිපි ලැබීම
    </div>

    <div class="card-body">
        <div class="row">
            <div class="col">

            </div>
            <div class="col">
                <canvas id="myChart"></canvas>
            </div>
        </div>
    </div>
</div>
<div class="card">

    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp; Received Month
    </div>

    <div class="card-body">

        <div class="datalist">
            <?php foreach (analyst::monthly_count() as $value) { ?>

                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col">
                            <?= $value["y"] . " &nbsp; " . $value["m"]; ?>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>


<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp;Received Method
    </div>
    <div class="card-body">

        <div class="datalist">
            <?php foreach (analyst::letters_by_received_method() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col-4 pe-2">
                            <?= $value["name"] ?>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>
                        <div class="col progress">
                            <div class="progress-bar" role="progressbar" style="width: <?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>%" aria-valuenow="<?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>

                        <div class="col col-w4 right">
                            <span class="text-muted text-strong"><?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?> %</span>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels">
</script>
<script>
    Chart.defaults.font.family = 'Yaldevi';
    Chart.defaults.font.size = 16;

    var data_labels = [];
    var data_values = [];
    var data = [];
    var alldata = [];
    var month_names = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

    function getRandomInt(max) {
        return Math.floor(Math.random() * max);
    }


    $.getJSON(API + "mail/stats/received.php", {
        year: 2023
    }, function(response) {
        console.log(response["data"]);
        response["data"].forEach(element => {
            data[element.day] = element;
        });

        for (let day = 1; day < 12; day++) {
            /*if (day % 30 == 15) {
                data_labels.push(month_names[2]);
            }
            if (data[day]) {
                data_values.push(data[day].count);
            } else {
                data_labels.push(" ");
                data_values.push(0);
            }*/
            data_labels.push(day);
            data_values.push(getRandomInt(40) + 60);
        }

        renderchart();
    });

    console.log(data_labels);

    function renderchart() {
        const ctx = document.getElementById('myChart');
        Chart.register(ChartDataLabels);
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: data_labels,
                datasets: [{
                    label: 'Letters',
                    data: data_values,
                    backgroundColor: [
                        'rgba(21, 143, 143,0.9)'
                    ],
                    borderRadius: 5
                }]
            },
            options: {
                indexAxis: 'y',
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 120,
                    }
                },
                plugins: {
                    datalabels: {
                        display: false,
                        // Position of the labels 
                        // (start, end, center, etc.)
                        anchor: 'end',
                        // Alignment of the labels 
                        // (start, end, center, etc.)
                        align: 'end',
                        font: {
                            weight: 'bold',
                            size: 12
                        },
                        formatter: function(value, context) {
                            // Display the actual data value
                            return value;
                        }
                    },
                    legend: {
                        display: false
                    },
                    tooltip: {
                        enabled: true
                    }
                }
            }
        });
    }
</script>

<?php page::footer(); ?>