<?php
require "../../../../src/config.php";

page::set([
    "title" => "Mail Stats - Recorded",
    "page_id" => "mail_stats_recorded",
    "nav-parent" => "mail_stats",
    "size" => "box-full",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

page::header();

?>
<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp;Recorded User
    </div>
    <div class="card-body">

        <div class="datalist">
            <?php foreach (analyst::letters_by_recorded() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col-4 m-auto">
                            <span class="tag-primary w-100 col-w3"># <?= $value["code"] ?></span>
                            <span class="text ps-2"><?= $value["name"] ?></span>
                            <span class="text-sm text-primary ps-2">#<?= $value["shortname"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-md text-strong"><?= $value["count"] ?></span>
                        </div>
                        <div class="col progress">
                            <div class="progress-bar" role="progressbar" style="width: <?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>%" aria-valuenow="<?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-muted text-strong"><?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?> %</span>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>
</div>

<div class="card">
    <div class="card-body">
        <canvas id="myChart"></canvas>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels">
</script>
<script>
    Chart.defaults.font.family = 'Yaldevi';
    Chart.defaults.font.size = 16;

    const ctx = document.getElementById('myChart');
    Chart.register(ChartDataLabels);
    new Chart(ctx, {
        type: 'scatter',
        data: {
            datasets: [{
                label: 'Scatter Dataset',
                data: [{
                    x: -10,
                    y: 0
                }, {
                    x: 0,
                    y: 10
                }, {
                    x: 10,
                    y: 5
                }, {
                    x: 0.5,
                    y: 5.5
                }],
                backgroundColor: 'rgb(255, 99, 132)'
            }],
        },
        options: {
            scales: {
                x: {
                    type: 'linear',
                    position: 'bottom'
                }
            }
        }
    });
</script>

<?php page::footer(); ?>