<?php
require "../../../../src/config.php";

page::set([
    "title" => "Mail Stats - Sender",
    "page_id" => "mail_stats_sender",
    "nav-parent" => "mail_stats",
    "size" => "box-full",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

page::header();

?>

<div class="card">

    <div class="card-body">

        <div class="datalist">
            <?php foreach (analyst::letters_by_sender() as $value) { ?>
                <div class="listitem">
                    <div class="row listitem-content">

                        <div class="col">
                            <?= $value["name"] ?>
                            <span class="text-xs text-muted"># <?= $value["shortname"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text text-strong"><?= $value["count"] ?></span>
                        </div>
                        <div class="col col-w4 right">
                            <span class="text-muted text-strong"><?= round($value["count"] / analyst::total_letter_count(), 2) * 100 ?> %</span>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

    </div>
</div>

<?php page::footer(); ?>