<?php
require "../../../src/config.php";

if (isset($_GET["id"])) {
    $letter = letters::get($_GET["id"]);
    if (!$letter) {
        error("Invalid Letter ID");
    }
} else {
    error("Invalid ID");
}

page::set([
    "title" => "Letter Summary",
    "nav-parent" => "letters",
    "size" => "box-full"
]);

page::header();
?>

<div class="row">

    <?php if (isset($_GET["new"])) { ?>

        <div class="card">
            <div class="card-body">

                <?php alert::success([
                    "text" => "Letter #" . $_GET["id"] . " Added to the Records Successfully",
                    "link" => "../update",
                    "link_text" => "Add Another Letter",
                    "autofocus" => true
                ]); ?>

            </div>

        </div>

    <?php } ?>

</div>

<div class="row">

    <div class="col-lg-6">

        <div class="card">

            <div class="card-body">

                <div class="datalist">

                    <div class="listitem <?= ($letter["sender_priority"] == 1) ? "listitem-important" : "" ?>">

                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("institution") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    එවූ ආයතනය
                                </div>
                                <div class="list-title">
                                    <?= $letter["sender_name"] ?>
                                </div>
                            </div>
                            <?php if ($letter["sender_priority"] == 1) { ?>
                                <div class="col col-w6 m-auto">
                                    <div class="tag-priority">PRIORITY</div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="listitem">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("hash") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    ලිපියේ අංකය
                                </div>
                                <div class="list-title">
                                    <?= $letter["number"] ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="listitem">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("date") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    ලිපියේ දිනය
                                </div>
                                <div class="list-title">
                                    <?= $letter["date"] ?>
                                </div>
                            </div>

                        </div>

                    </div>



                </div>

                <a class="btn btn-primary text-xs float-end" href="../update?id=<?= $letter["id"] ?>">
                    Edit
                </a>

            </div>

        </div>

        <div class="letter" hidden>

            <div class="row">
                <div class="col center">

                    <div class="letter-datestamp">
                        <div class="letter-source"><?= $letter["source_name"] ?> </div>
                        <div class="letter-received"><?= $letter["received"] ?></div>
                    </div>

                </div>
                <div class="col- m-auto">
                    <span class="letter-id"># <?= $letter["id"] ?></span>
                </div>
                <div class="col right">
                    <a href="../update?id=<?= $letter["id"] ?>" class="btn btn-primary float-end right"><?= UI::icon("edit") ?>Edit</a>
                </div>
            </div>

            <div class="letter-heading my-3">
                <span class="letter-sender letter-highlighted-content">
                    <?= $letter["sender_name"] ?>
                </span>
                <div class="letter-meta">
                    <div class="row">
                        <div class="col left">
                            <span class="text-muted">අංකය</span> <span class="text-strong ms-2 letter-highlighted-content"><?= $letter["number"] ?></span>
                        </div>
                        <div class="col right">
                            <span class="text-muted">දිනය</span> <span class="text-strong ms-2 letter-highlighted-content"><?= $letter["date"] ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="py-2">

                <span class="letter-title letter-highlighted-content">
                    <?= $letter["title"] ?>
                </span>
                <div class="letter-body text-muted">
                    "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud"
                </div>

                <div class="row">
                    <div class="col-5">
                        <div class="letter-signature">
                            <img src="/<?= SUBFOLDER ?>src/images/fakesignature.png" alt="" srcset="">
                        </div>
                        <div class="left text-muted">
                            අත්සන් කල නිලධාරී <br>
                            <?= $letter["sender_name"] ?>
                        </div>
                    </div>
                    <div class="col">
                        <div class="cs-seal">
                            <?php if ($letter["cs"]) { ?>
                                <img src="/<?= SUBFOLDER ?>src/images/cs_seal.png" alt="" srcset="">
                            <?php } ?>
                        </div>
                        <div class="cs-seal">
                            <?php if ($letter["cs"]) { ?>
                                <img src="/<?= SUBFOLDER ?>src/images/priority_seal.png" alt="" srcset="">
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col">
                        <div class="cs-seal">
                            <div class="tag-dcs-ad"><?= $letter["forwarded_shortname"] ?></div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
        <div class="card">

            <div class="card-body">



                <div class="datalist">

                    <div class="listitem <?= (empty($letter["forwarded_name"])) ? "listitem-attention" : "" ?>">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("forward") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    යොමුකල අංශය
                                </div>
                                <?php if (!empty($letter["forwarded_name"])) { ?>
                                    <div class="text">
                                        <?= $letter["forwarded_name"] ?>
                                        <div class="ms-2 tag-<?= $letter["forwarded_codename"] ?>">
                                            <?= $letter["forwarded_shortname"] ?>
                                        </div>
                                    </div>
                                    <div class="text-xs text-muted">Forwarded by
                                        <?= $letter["forwarded_by_user"] ?> @
                                        <?= $letter["forwarded_at"] ?>
                                    </div>
                                <?php } else { ?>
                                    <span class="text-danger text-strong">යොමුකල අංශය සඳහන් කර නොමැත</span>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="listitem <?= (empty($letter["assigned_name"])) ? "listitem-attention" : "" ?>">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?php if (empty($letter["assigned_name"])) { ?>
                                    <?= UI::icon("user") ?>
                                <?php } else { ?>
                                    <div class="avatar-sm">
                                        <img class="" src="/<?= SUBFOLDER ?>src/images/users/<?= $letter["assigned"] ?>.png" onerror="this.src='/<?= SUBFOLDER ?>src/images/users/default.png';">
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    විෂය නිලධාරී
                                </div>
                                <div class="list-title">
                                    <?php if (empty($letter["assigned_name"])) { ?>
                                        <span class="text-danger text-strong">නොදනී
                                            <?= UI::icon("progress-state-1") ?>
                                        </span>
                                    <?php } else { ?>
                                        <?= $letter["assigned_name"] ?> <span class="text-sm text-strong text-primary ms-2">#
                                            <?= $letter["assigned_shortname"] ?>
                                        </span>
                                        <div class="text-xs text-muted">Assigned by
                                            <?= $letter["assigned_by_user"] ?> @
                                            <?= $letter["assigned_at"] ?>
                                        </div>
                                    <?php } ?>
                                </div>

                            </div>

                            <?php if (userroles::is_assigned("manager")) { ?>
                                <div class="col col-w4 m-auto">
                                    <a class="btn btn-primary text-xs float-end" href="../assign?id=<?= $letter["id"] ?>">
                                        <?= empty($letter["assigned_name"]) ? "Assign" : "Change" ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="listitem <?= (empty($letter["file_number"])) ? "listitem-attention" : "" ?>">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("file") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    ගොනුව
                                </div>
                                <?php if (!empty($letter["file_number"])) { ?>
                                    <span class="text">
                                        <?= $letter["file_number"] ?>
                                    </span>
                                <?php } else { ?>
                                    <span class="text-danger text-strong">නොදනී
                                        <?= UI::icon("progress-state-1") ?>
                                    </span>
                                <?php } ?>
                            </div>
                            <?php if ($letter["assigned"] == auth::user_id()) { ?>
                                <div class="col col-w4 m-auto">
                                    <a class="btn btn-primary text-xs float-end" href="/<?= SUBFOLDER ?>user/mail/updatefile?id=<?= $letter["id"] ?>">
                                        Update
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>


                </div>

            </div>
        </div>

        <div class="card">

            <div class="card-title">
                ගෙන ඇති ක්‍රියාමාර්ග
            </div>

            <div class="p-3">

                <?php if (auth::user_id() == $letter["assigned"]) { ?>
                    <a class="btn btn-primary" href="/<?= SUBFOLDER ?>user/mail/update?id=<?= $letter["id"] ?>"><?= UI::icon("edit") ?> Edit</a>
                <?php } ?>

                <?php if (auth::user_id() == $letter["assigned"] || userroles::is_assigned("spectator")) { ?>
                    <a href="/<?= SUBFOLDER ?>mail/letters/summary/notes?l=<?= $_GET["id"] ?>" class="btn btn-success">Add Note</a>
                <?php } ?>

            </div>



            <div class="datalist">
                <?php foreach (notes::byletter($_GET["id"]) as $key => $value) { ?>

                    <div class="listitem">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("note") ?>
                            </div>
                            <div class="col">
                                <div class="text-xs text-primary">
                                    <span class=""><?= $value["date"] ?></span>
                                    <span class="mx-2"><?= $value["user_name"] ?></span>

                                </div>
                                <div class="text"> <?= $value["note"] ?></div>
                            </div>
                            <div class="col col-w2 m-auto mt-2">
                                <a href="/<?= SUBFOLDER ?>user/mail/notes?id=<?= $value["id"] ?>"><?= UI::icon("edit") ?></a>
                            </div>
                        </div>
                    </div>


                <?php } ?>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-title">ගත් ක්‍රියාමාර්ග සහ වර්තමාන තත්වය</div>
            <div class="card-body">

                <div class="datalist">
                    <div class="listitem <?= ($letter["state"] == 1) ? "listitem-attention" : "" ?>">
                        <div class="row listitem-content">
                            <div class="col li-icon">
                                <?= UI::icon("progress") ?>
                            </div>
                            <div class="col">
                                <div class="li-label">
                                    වර්තමාන තත්වය
                                </div>
                                <div class="progress-text-<?= $letter["state"] ?> text-strong">
                                    <span class="text">
                                        <?= $letter["current_state"] ?>
                                    </span>
                                    <span class="">
                                        <?= UI::icon("progress-state-" . $letter["state"]) ?>
                                    </span>
                                </div>
                            </div>
                            <?php if (auth::user_id() == $letter["assigned"]) { ?>
                                <div class="col col-w4 m-auto">
                                    <a class="btn btn-primary text-xs float-end" href="/<?= SUBFOLDER ?>user/mail/updatestate?id=<?= $letter["id"] ?>">Update</a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                </div>

            </div>

        </div>

        <div class="card">
            <div class="card-title">Timeline</div>
            <div class="card-body">

                <div class="timeline" id="timeline"></div>
                <?php if (auth::user_id() == $letter["assigned"] || userroles::is_assigned("spectator")) { ?>
                    <a href="/<?= SUBFOLDER ?>mail/letters/summary/notes?l=<?= $_GET["id"] ?>" class="btn btn-success">
                        <?= UI::icon("add") ?> Add Note
                    </a>
                <?php } ?>

            </div>

        </div>
    </div>

</div>

<script id="timeline_template" type="text/template">

    {{#events}}
        <div class="timeline-item {{#event}}timeline-item-event{{/event}} {{#note}}timeline-item-note{{/note}} {{#warning}}timeline-item-warning{{/warning}}">

            <div class="row">

                <div class="col col-w5">

                    <div class="timeline-date">
                        <div class="date">
                            {{date}}
                        </div>
                        {{#time}}
                            <div class="time">
                                {{time}}
                            </div>
                        {{/time}}
                    </div>

                </div>

                <div class="col timeline-vine">
                    <div class="dot"></div>
                    <div class="line"></div>
                </div>
                <div class="col col-w3">
                    {{{icon}}}
                </div>

                <div class="col timeline-content">
                    {{#content}}

                        <div class="timeline-content-title">
                            {{title}}
                            {{#editor}}
                                <a href="/<?= SUBFOLDER ?>mail/letters/summary/notes?id={{id}}" class="float-end text-xs"><?= UI::icon("recorded") ?></a>
                            {{/editor}}
                        </div>
                        {{#text}}
                            <div class="timeline-content-text">
                                {{text}}

                            </div>
                        {{/text}}

                    {{/content}}
                </div>

                <div class="col col-w3">
                    <div class="timeline-duration">
                        <span class="days">{{days}}</span>
                    </div>
                </div>



            </div>
        </div>
    {{/events}}
</script>

<script>
    $.getJSON(API + "mail/letter/timeline.php", {
        id: <?= intval($_GET["id"]) ?>
    }, function(response) {
        render(response);
    });

    function render(render_data) {
        var template = $("#timeline_template").html();
        content = Mustache.render(template, render_data);
        $("#timeline").html(content);
    }
</script>

<?php page::footer(); ?>