<?php

// TODO - Deprecate 
class UI
{

  public static function icon($i, $a = "none")
  {

    if (isset(self::$icons[$i])) {
      return '<i class="' . self::$icons[$i] . ' ' . self::$animations[$a] . ' icon"></i>';
    } elseif (str_starts_with($i, 'file-')) {
      return '<i class="fa-regular fa-file"></i>';
    } else {
      return '<i class="fas fa-' . $i . '"></i>';
    }
  }

  private static $icons = array(
    "taxib" => "fa fa-taxi fa-lg",
    "app" => "fab fa-app-store",
    "web" => "fas fa-globe-africa",
    "info" => "fas fa-info-circle",
    "id" => "fas fa-hashtag",
    "username" => "fa fa-info",
    "password" => "fa fa-key",
    "login" => "fas fa-sign-in-alt",
    "logout" => "fas fa-power-off",
    "registered" => "fa-regular fa-registered",
    "profile" => "fas fa-user-circle",
    "phonebook" => "far fa-address-book",
    "money" => "fas fa-dollar-sign",
    "delete" => "fas fa-times",
    "search" => "fas fa-search",
    "user" => "far fa-user",
    "users" => "fas fa-users",
    "capacity" => "fas fa-users",
    "publication" => "far fa-bookmark",
    "plus" => "fas fa-plus",
    "minus" => "fas fa-minus",
    "car" => "fas fa-taxi",
    "contact" => "fas fa-address-card",
    "mail" => "far fa-envelope",
    "view" => "fas fa-eye",
    "hidden" => "fa-solid fa-eye-slash",
    "phone" => "fa-solid fa-phone",
    "call" => "fas fa-phone-alt",
    "star" => "fas fa-star",
    "back" => "fa-solid fa-arrow-left",
    "date" => "fa-regular fa-calendar",
    "calender" => "fa-regular fa-calendar-check",
    "time" => "far fa-clock",
    "notice" => "far fa-comment-alt",
    "home" => "fas fa-home",
    "location" => "fas fa-map-marker-alt",
    "edit" => "fa-solid fa-pen-to-square",
    "bars" => "fas fa-bars",
    "list" => "far fa-list-alt",
    "dropoff" => "fas fa-long-arrow-alt-right",
    "return" => "fas fa-exchange-alt",
    "distance" => "fas fa-arrows-h",
    "state" => "fas fa-asterisk",
    "pending" => "fas fa-exclamation-circle",
    "confirmed" => "fas fa-check",
    "active" => "fas fa-sync-alt",
    "map" => "fas fa-map-marked-alt",
    "verified" => "fas fa-check-circle",
    "loading" => "fas fa-spinner",
    "load" => "fas fa-sync-alt",
    "warning" => "fas fa-exclamation-triangle",
    "password" => "fas fa-key",
    "country" => "fas fa-globe-africa",
    "log" => "fas fa-list-ul",
    "picture" => "fa-solid fa-image",
    "copy" => "far fa-copy",
    "error" => "fa-solid fa-circle-xmark",
    "orgchart" => "fa-solid fa-sitemap",
    "whatsapp" => "fab fa-whatsapp",
    "settings" => "fas fa-cog",
    "theme" => "fas fa-palette",
    "link" => "fas fa-link",
    "hash" => "fas fa-hashtag",
    "birthday" => "fas fa-birthday-cake",
    "online" => "fas fa-satellite-dish",
    "tools" => "fas fa-tools",
    "balance" => "fas fa-balance-scale",
    "downloads" => "fas fa-download",
    "history" => "fas fa-history",
    "hourglass" => "fas fa-hourglass-half",
    "quote-left" => "fas fa-quote-left",
    "quote-right" => "fas fa-quote-right",
    "sort" => "fas fa-sort-amount-down-alt",
    "notifications" => "far fa-bell",
    "menu" => "fas fa-bars",
    "news" => "fas fa-newspaper",
    "stats"  => "far fa-chart-bar",
    "question" => "fas fa-question",
    "updated" => "fas fa-check-circle",
    "success" => "fas fa-check-circle",
    "whatsapp"  =>  "fab fa-whatsapp",
    "announcement" => "fa-solid fa-bullhorn",
    "external-link" => "fas fa-external-link-alt",
    "email" => "fas fa-at",
    "institution" => "fas fa-landmark",
    "report" => "far fa-file-alt",
    "download" => "fas fa-arrow-down",
    "text" => "fas fa-font",
    "content" => "fas fa-paragraph",
    "publisher" => "fas fa-pen-alt",
    "light" => "fas fa-sun",
    "dark" => "fas fa-moon",
    "institution" => "fas fa-landmark",
    "admin" => "fa-solid fa-gear",
    "form" => "fa-solid fa-file-lines",
    "arrow-down" => "fa-solid fa-angle-down",
    "under-construction" => "fa-solid fa-person-digging",
    "suppliers" => "fa-solid fa-boxes-packing",
    "role" => "fa-solid fa-hat-cowboy",
    "lock" => "fa-solid fa-lock",
    "summary" => "fa-solid fa-chart-simple",
    "stats" => "fa-solid fa-chart-simple",
    "received" => "fa-solid fa-right-to-bracket",
    "forwarded" => "fa-solid fa-arrow-up-right-from-square",
    "forward" => "fa-solid fa-angles-right",
    "smart-stats" => "fa-solid fa-magnifying-glass-chart",
    "recorded" => "fa-solid fa-pen",
    "assigned" => "fa-solid fa-user-plus",
    "file" => "fa-regular fa-folder",
    "addfile" => "fa-solid fa-folder-plus",
    "note" => "fa-regular fa-message",
    "progress" => "fas fa-chart-line",
    "completed" => "fa-regular fa-circle-check",
    "unknown" => "fa-solid fa-circle-question",
    "active" => "fa-regular fa-envelope-open",
    "delayed" => "fa-solid fa-skull",
    "late3" => "fa-solid fa-skull",
    "provincial" => "fa-regular fa-flag",
    "inventory" => "fa-solid fa-dolly",
    "item-Monitor" => "fa-solid fa-dolly",
    "item-KeyBoard" => "fa-regular fa-keyboard",
    "diary" => "fa-regular fa-calendar-check",
    "legal" => "fa-solid fa-scale-balanced",
    "file-pdf" => "fas fa-file-pdf",
    "file-jpg" => "far fa-file-image",
    "file-docx" => "fa-solid fa-file-word",
    "file-doc" => "fa-solid fa-file-word",
    "file-dot" => "fa-solid fa-file-word",
    "file-xlsx" => "fa-solid fa-file-excel",
    "file-xls" => "fa-solid fa-file-excel",
    "file-ppt" => "fa-solid fa-file-powerpoint",
    "file-ttf" => "fa-solid fa-font",
    "file-jpg" => "fa-solid fa-file-image",
    "file-jpeg" => "fa-solid fa-file-image",
    "file-png" => "fa-regsolidular fa-file-image",
    "file-zip" => "fa-solid fa-file-zipper",
    "file-mp3" => "fa-solid fa-file-audio",
    "signature" => "fa-solid fa-pen-clip"
  );

  private static $animations = array(
    "none" => " ",
    "flash" => "faa-flash animated",
    "spin" => "faa-spin animated",
    "burst" => "faa-burst animated"
  );

  public static function success($message, $content = [])
  {
    return self::alertx("success", $message, $content);
  }

  public static function warning($message, $content = [])
  {
    return self::alertx("warning", $message, $content);
  }

  public static function error($message)
  {
    return self::alertx("error", $message);
  }

  public static function info($message, $content = [])
  {
    return self::alertx("info", $message, $content);
  }

  public static function announcement($message, $content = [])
  {
    return self::alertx("announcement", $message, $content);
  }


  private static function alertx($type, $title, $content = [])
  { ?>

    <div class="alert alert-<?= $type ?>">
      <div class="row">
        <div class="col alert-icon"><?= UI::icon($type) ?></div>
        <div class="col m-auto">
          <div class="alert-title"><?= $type ?></div>
          <div class="alert-text">
            <?= $title ?>
          </div>

          <?php if (!empty($content)) { ?>

            <div class="alert-content">
              <ul>
                <?php foreach ($content as $text) {
                  echo "<li class=' '>" . $text . "</li>";
                } ?>
              </ul>
            </div>

          <?php } ?>

        </div>
      </div>
    </div>

<?php }

  public static function theme()
  {
    return "light";
  }
}
