<?php

class alert
{

  private static $settings = array(
    "type" => "success",
    "icon" => "info",
    "title" => null,
    "text" => "Deault Alert Text",
    "button" => [
      "icon" => "info",
      "text" => "Action",
      "link" => "#"
    ],
    "list" => []
  );

  public static function success($data)
  {
    $data["icon"] = "success";
    $data["type"] = "success";
    $data["title"] = "success";

    return self::show($data);
  }

  public static function announcement($data)
  {
    $data["icon"] = "announcement";
    $data["type"] = "announcement";
    $data["title"] = "announcement";

    return self::show($data);
  }

  private static function show($data)
  { ?>

    <div class="alert alert-<?= $data["type"] ?>">
      <div class="row">
        <div class="col alert-icon"><?= icons::get($data["icon"]) ?></div>
        <div class="col m-auto">
          <div class="alert-title"><?= $data["title"] ?></div>
          <div class="alert-text">
            <?= $data["text"] ?>
          </div>

          <?php if (!empty($content)) { ?>

            <div class="alert-content">
              <ul>
                <?php foreach ($content as $text) {
                  echo "<li class=' '>" . $text . "</li>";
                } ?>
              </ul>
            </div>

          <?php } ?>


          <?php if (isset($data["link"])) { ?>
            <a class="btn btn-<?= $data["type"] ?> my-2" href="<?= $data["link"] ?>" <?= isset($data["autofocus"]) ? "autofocus" : "" ?>><?= UI::icon("add") . " " . $data["link_text"] ?> </a>
          <?php } ?>

        </div>

      </div>
    </div>

<?php }
}
