<?php

// Time difference between two timestamps
function timediff_text($a, $b)
{
    $diff = strtotime($a) - strtotime($b);
    $hours = floor($diff / 3600);
    $minutes = round($diff % 3600 / 60);

    $text = $minutes . " minutes";
    if ($hours > 0) {
        $text = $hours . " hours " . $text;
    }

    return $text;
}

function timefrom($time)
{

    $now = date('Y-m-d H:i:s');

    $diff = strtotime($now) - strtotime($time);

    $days    = floor($diff / (60 * 60 * 24));

    if ($days > 1) {
        return $days . " days ago";
    }

    if ($days == 1) {
        return " Yesterday";
    }

    $hours   = floor($diff / (60 * 60));
    if ($hours > 1) {
        return $hours . " hours ago";
    }

    if ($hours == 1) {
        return "an hour ago";
    }

    $minutes   = floor($diff / 60);

    if ($minutes > 1) {
        return $minutes . " minutes ago";
    }

    return "Few seconds ago";
}

function time_remaining($time)
{

    $now = date('Y-m-d H:i:s');

    $diff = strtotime($time) - strtotime($now);

    $days    = floor($diff / (60 * 60 * 24));

    if ($days > 1) {
        return $days . " days";
    }

    if ($days == 1) {
        return " Tommorow";
    }

    $hours   = floor($diff / (60 * 60));
    if ($hours > 1) {
        return $hours . " hours";
    }

    if ($hours == 1) {
        return "an hour";
    }

    $minutes   = floor($diff / 60);

    if ($minutes > 1) {
        return $minutes . " minutes";
    }

    return "Few seconds";
}

function getHoursMinutes($minutes)
{

    $h = floor($minutes / 60);
    $m = ($minutes % 60);
    if ($h > 0) {
        $text = $h . " hours " . $m . " minutes";
    } else {
        $text = $m . " minutes";
    }

    return $text;
}

// get current timestamp to store in database
function timestamp()
{
    return date('Y-m-d H:i:s');
}

function dayname($d)
{
    $days = ["සඳුදා", "අඟහරුවාදා", "බදාදා", "බ්‍රහස්පතින්දා", "සිකුරාදා", "සෙනසුරාදා", "ඉරිදා"];
    return $days[$d - 1];
}
