<?php

class form
{

    public static function update_state($input)
    {

        //display($input);
        echo "<div class='update-state-text'>";

        if (isset($input["updated"])) {
            echo "<div class='text-success'>Updated" . UI::icon("updated") . "</div>";
        } else if (isset($input["warnings"])) {
            echo "<div class='text-danger'>";
            foreach ($input["warnings"] as $key => $value) {
                echo $value . "<br>";
            }
            echo "</div>";
        }
        echo "</div>";
    }

    public static function inputstate_text($input)
    {

        if ($input["valid"]) {
            if ($input["updated"]) {
                echo "updated";
            } else {
                echo "Not updated";
            }
        } else {
            foreach ($input["warnings"] as $key => $value) {
                echo $value . "<br>";
            }
        }
    }

    public static function response_summary($response)
    {

        if (isset($response["errors"])) {
            foreach ($response["errors"] as $key => $value) {
                echo UI::error($value);
            }
        }

        if (isset($response["warnings"])) {
            foreach ($response["warnings"] as $key => $value) {
                echo UI::warning($value);
            }
        }

        if ($response["success"] && $response["action"] == "create") {
            echo UI::success("New Record Created Successfully");
        }

        $updated = [];
        $invalid = [];

        foreach ($response["data"] as $key => $value) {

            if (isset($value["updated"])) {
                //$updated[] = $key;
                echo UI::success("'" . $key . "' Updated");
            }

            if (!$value["valid"]) {

                foreach ($value["warnings"] as $w) {
                    $invalid[] = $key . " - " . $w;
                }
                //$invalid = array_merge($invalid, $value["warnings"]);
            }

            if (isset($value["error"])) {
                echo UI::error($key . " : " . $value["error"]);

                //$invalid = array_merge($invalid, $value["warnings"]);
            }
        }

        /*if (!empty($updated)) {
                echo UI::success("Updated", $updated);
            }*/

        if (!empty($invalid)) {
            echo UI::warning("Invalid Inputs Found", $invalid);
        }
    }
}
