<?php

class navigation
{

    public static function sidemenu()
    {

        $sidemenu = [
            "cases" => [
                "icon" => "summary",
                "title" => "Cases ",
                "items" => array(
                    "cases_search" => array(
                        "icon" => "search",
                        "link" => "cases/search",
                        "text" => "Search"
                    ),
                    "case_update" => array(
                        "icon" => "plus",
                        "link" => "cases/update",
                        "text" => "New Case"
                    ),
                    "cases_all" => array(
                        "icon" => "mail",
                        "link" => "cases/all",
                        "text" => "Cases"
                    ),
                    "reports" => array(
                        "icon" => "report",
                        "link" => "cases/reports",
                        "text" => "Reports"
                    )
                )
            ],
            "profile" => [
                "icon" => "profile",
                "title" => "Profile ",
                "items" => array(
                    "user_profile_" . auth::user_id() => array(
                        "icon" => "profile",
                        "link" => "user/profile",
                        "text" => "Profile"
                    )
                )
            ],
            "admin" => [
                "icon" => "summary",
                "title" => "Administrator ",
                "access" => ["admin"],
                "items" => array(
                    "admin_users" => array(
                        "icon" => "admin",
                        "text" => "Admin",
                        "links" => [
                            "admin_institutions" => array(
                                "icon" => "institution",
                                "link" => "admin/institutions",
                                "text" => "institutions"
                            ),
                            "admin_users" => array(
                                "icon" => "user",
                                "link" => "admin/users",
                                "text" => "Users"
                            )
                        ]
                    ),
                )
            ]
        ];

        //ksort($sidemenu);

        return $sidemenu;
    }
}
