<?php

class page
{
    // Default page settings, 
    private static $settings = array(
        "title" => "CS MIS",
        "page_id" => null,
        "nav-id" => null,
        "nav-parent" => null,
        "size" => "box-full",
        "appbar" => false,
        "sidemenu" => true,
        "toolbar" => null,
        "layout" => "admin",
        "permission" => null,
        "scripts" => ["jquery", "helpers", "bootstrap5", "mustache"]
    );

    public static function set($custom_settings)
    {

        // TODO?? - shouldn't we loop through $settings to avoid non-defined keys inside settings array
        foreach ($custom_settings as $key => $value) {

            if (array_key_exists($key, self::$settings)) {  // To ignore unintended settings
                if (is_array(self::$settings[$key])) {
                    self::$settings[$key] = array_merge(self::$settings[$key], $value);
                } else {
                    self::$settings[$key] = $custom_settings[$key];
                }
            }
        }
    }

    public static function get($key)
    {
        if (isset(self::$settings[$key])) {
            return self::$settings[$key];
        } else {
            return null;
        }
    }

    public static function access_control($allowed_roles)
    {
        // user need to be logged in
        if (!auth::user()) {
            router::redirect("login");
        }

        $permission = false;

        foreach ($allowed_roles as $role) {
            if (userroles::is_assigned($role)) {
                $permission = true;
                break;
            }
        }

        if (!$permission) {
            router::redirect("profile");
        }
    }

    public static function submitted()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            return true;
        } else {
            return false;
        }
    }

    public static function header()
    {
        require FILE_ROOT . "src/layouts/" . self::$settings['layout'] . "/header.php";
    }

    public static function footer()
    {
        require FILE_ROOT . "src/layouts/" . self::$settings['layout'] . "/footer.php";
    }

    public static function scripts()
    {
        $scripts = [
            "jquery" => [
                "local" => "jquery.min.js"
            ],
            "helpers" => [
                "local" => "helpers.js"
            ],
            "mustache" => [
                "local" => "mustache.js"
            ],
            "bootstrap5" => [
                "cdn" => "https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
            ],
            "simpleparallax" => [
                "cdn" => "https://cdn.jsdelivr.net/npm/simple-parallax-js@5.5.1/dist/simpleParallax.min.js"
            ],
            "aos" => [
                "cdn" => "https://unpkg.com/aos@2.3.1/dist/aos.js"
            ],
            "pickday" => [
                "local" => "pickday.js"
            ],
            "clockpicker" => [
                "local" => "clockpicker.min.js"
            ],
            "pdfjs" => [
                "cdn" => "https://cdnjs.com/libraries/pdf.js"
            ],
            "chosen" => [
                "cdn" => "https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.jquery.min.js"
            ],
            "chartjs" => [
                "cdn" => "https://cdn.jsdelivr.net/npm/chart.js"
            ],
            "highcharts" => [
                "cdn" => "https://code.highcharts.com/dashboards/dashboards.js"
            ],
            "popper" => [
                "cdn" => "https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
            ]
        ];

        foreach (self::$settings['scripts'] as $script) {

            if (!isset($scripts[$script])) {
                continue;
            }
            echo '  <!-- ' . $script . ' -->';
            if (isset($scripts[$script]['local'])) {
                echo '<script src="/' . SUBFOLDER . 'src/scripts/' . $scripts[$script]['local'] . '"></script>';
            } else if (isset($scripts[$script]['cdn'])) {
                echo '<script src="' . $scripts[$script]['cdn'] . '"></script>';
            }
        }
    }
}
