<?php
/*============================================================================
Function in validator class checks the validity of a value and gives warnings
==============================================================================*/
class validator
{
    private static function return($warnings)
    {
        if (empty($warnings)) {
            return ["success" => true];
        } else {
            return ["success" => false, "warnings" => $warnings];
        }
    }

    public static function nonempty($input)
    {
        $warnings = [];
        if (empty($input)) {
            $warnings[] = "cannot be an empty string";
        } else if (ctype_space($input)) {
            $warnings[] = "cannot be only spaces";
        }

        return self::return($warnings);
    }

    public static function number($input)
    {
        $warnings = [];
        if (!is_numeric($input)) {
            $warnings[] = "Not a number";
        }
        return self::return($warnings);
    }

    public static function phone($input)
    {
        $warnings = [];
        if ($input < 500000000 || $input > 820000000) {
            $warnings[] = "Not a valid phone number";
        }
        return self::return($warnings);
    }

    public static function year($input)
    {
        $warnings = [];

        $year = intval($input);
        if ($year < 2020 || $year > 2100) {
            $warnings[] = "Year value must be between 2020 and 2100";
        }
        return self::return($warnings);
    }

    public static function switch($input)
    {
        $warnings = [];
        if (!in_array($input, [0, 1])) {
            $warnings[] = "Switch input should be 1 or 0";
        }
        return self::return($warnings);
    }

    public static function email($input)
    {
        $warnings = [];
        if (!filter_var($input, FILTER_VALIDATE_EMAIL)) {
            $warnings = "Not a valid email address";
        }
        return self::return($warnings);
    }

    public static function datetime($input)
    {
        $warnings = [];
        if (!strtotime($input)) {
            $warnings = "Not a valid datetime value";
        }
        return self::return($warnings);
    }

    public static function time($input)
    {
        // TODO: Check specifically for a time value
        return self::datetime($input);
    }

    public static function date($input)
    {
        // TODO: Check specifically for a date value
        return self::datetime($input);
    }

    public static function filetypes($input)
    {
        $warnings = [];
        $allowed_filetypes = ["pdf", "zip"];
        if (!in_array($input, $allowed_filetypes)) {
            $warnings[] = $input . " Files Not allowed";
        }
        return self::return($warnings);
    }

    public static function text_english($input)
    {
        $warnings = [];

        if (strlen($input) != mb_strlen($input, 'utf-8')) {
            $warnings[] = "Non english characters detected";
        }

        return self::return($warnings);
    }

    public static function username($value)
    {
        $warnings = [];

        // check for white spaces
        if (preg_match('/\s/', $value)) {
            $warnings[] = "Spaces are not allowed in Username";
        }

        // check for length
        if (strlen($value) < 4) {
            $warnings[] = "Username should be atleast 4 characters";
        }

        return self::return($warnings);
    }

    public static function password($value)
    {
        $warnings = [];

        if (strlen($value) < 5) {
            $warnings[] = "Password should be atleast 5 characters";
        }

        if (preg_match('/\s/', $value)) {
            $warnings[] = "Password can't contain spaces";
        }

        return self::return($warnings);
    }

    public static function letterstate($value)
    {
        $warnings = [];

        if (datatable::query("select * from mis_letter_states where id = :id", ["id" => $value])["count"] == 0) {
            $warnings[] = "Invalid State value";
        }

        return self::return($warnings);
    }
}
