<?php
$current_user = users::get(auth::user_id());

$appbar_navigation = [
    [
        "text" => "Home",
        "icon" => "home",
        "link" => "/"
    ],
    [
        "text" => "Users",
        "icon" => "users",
        "link" => "/user/all"
    ],
    [
        "text" => "Mail",
        "icon" => "mail",
        "link" => "/modules/mail/all"
    ],
    [
        "text" => "Inventory",
        "icon" => "inventory",
        "link" => "/modules/inventory/all"
    ],
    [
        "text" => "Downloads",
        "icon" => "download",
        "link" => "/modules/archive"
    ],
    [
        "text" => "Admin",
        "icon" => "admin",
        "link" => "/admin"
    ]
];

?>

<nav id="appbar">

    <div class="row h-100">

        <div class="col-w12 appbar-user">

            <a class="" href="<?= SUBFOLDER ?>/user/profile">
                <div class="row">
                    <div class="col col-w4 avatar">
                        <img class=" " src="/<?= SUBFOLDER ?>src/images/users/<?= auth::user_id() ?>.png" onerror="this.src='/<?= SUBFOLDER ?>src/images/users/default.png';">
                    </div>
                    <div class="col col-w8 username">
                        <?= auth::user_name() ?>
                    </div>
                </div>
            </a>

        </div>

        <?php foreach ($appbar_navigation as $key => $value) { ?>

            <div class="col navlink-container">
                <a class="pill" href="<?= SUBFOLDER . $value["link"] ?>">
                    <span class="pill-icon"><?= UI::icon($value["icon"]) ?></span>
                    <span class="pill-text text-xs"><?= $value["text"] ?></span>
                </a>
            </div>

        <?php }  ?>

        <div class="col">


        </div>

        <div class="col col-w4 logout">
            <a class=" " href="#"><?= UI::icon("dark") ?> </a>
        </div>

        <div class="col col-w4 logout">
            <a class=" " href="<?= SUBFOLDER ?>/user/all"><?= UI::icon("users") ?> </a>
        </div>

        <div class="col-w12 m-auto">
            <a class="pill bg-danger text-light flot-right" href="/user/profile/logout"><?= UI::icon("logout") ?> Logout </a>
        </div>

    </div>

</nav>

<div id="appbar-shadow"></div>