<!DOCTYPE html>

<head>
  <title><?= page::get("title") ?></title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- Bootstrap -->
  <link rel="stylesheet" href="/<?= SUBFOLDER ?>src/styles/bootstrap5.min.css">

  <!-- Custom styles -->
  <link rel="stylesheet" href="/<?= SUBFOLDER ?>src/styles/styles.css">
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

  <!-- Favicon -->
  <link rel="icon" type="image/png" href="/<?= SUBFOLDER ?>src/images/favicon.png">

  <!-- Custom font   -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Yaldevi:wght@400;600&display=swap" rel="stylesheet">

  <!-- Icon Font -->
  <link rel="stylesheet" href="/<?= SUBFOLDER ?>src/styles/fontawesome.min.css">
  <link rel="stylesheet" href="/<?= SUBFOLDER ?>src/styles/fontawesome-animation.min.css">

  <?php page::scripts() ?>
  <script>
    const UI_loading = '<div class="spinner"><?= UI::icon("loading", "spin"); ?></div>';
    const API = '/<?= SUBFOLDER ?>api/';
    const API_admin = '/<?= SUBFOLDER ?>admin/api/';
    const SRC = '/<?= SUBFOLDER ?>src/';
    const HOME = '/<?= SUBFOLDER ?>';
  </script>
  <script href="/<?= SUBFOLDER ?>src/scripts/helpers.js"></script>

</head>

<body>

  <?php

  if (page::get("appbar")) {
    include FILE_ROOT . "src/layouts/admin/appbar.php";
  }


  if (page::get("sidemenu")) {
    include FILE_ROOT . "src/layouts/admin/sidemenu.php";
  }


  ?>

  <div id="ribbon">

    <?php

    if (page::get("toolbar")) {
      if (file_exists(page::get("toolbar") . "toolbar.php")) {
        include page::get("toolbar") . "toolbar.php";
      } else {
        echo page::get("toolbar") . "toolbar.php doesn't exist";
      }
    } else if (file_exists("toolbar.php")) { // to be deprecated
      require "toolbar.php";
    }

    ?>

  </div>

  <div id="page">

    <div id="ribbon-shadow"></div>

    <div class="m-auto <?= page::get("size") ?>" id="page-content">