<?php

function checkpermission($menuitem)
{
    if (isset($menuitem["access"])) {

        foreach ($menuitem["access"] as $key => $value) {
            if (userroles::is_assigned($value)) {
                return true;
            }
        }
    } else {
        return true;
    }

    return false;
}

function sidemenu_linkitem($itemkey, $itemdata)
{

    if (isset($itemdata["access"]) && !checkpermission($itemdata)) {
        return;
    }
?>
    <div class="sidemenu-item <?= (page::get('nav-parent') == $itemkey) ? "active" : "" ?>">

        <a href="/<?= SUBFOLDER . $itemdata['link'] ?>">
            <?php sidemenu_itemcontent($itemdata) ?>
        </a>

    </div>

<?php }

function sidemenu_itemcontent($itemdata)
{ ?>
    <div class="sidemenu-item-content">
        <div class="row">
            <div class="col icon">
                <?= UI::icon($itemdata['icon']) ?>
            </div>
            <div class="col text">
                <span class="text">
                    <?= $itemdata['text'] ?>
                </span>
                <?php if (isset($itemdata["badge"]) && $itemdata["badge"] > 0) { ?>
                    <span class="badge">
                        <?= $itemdata["badge"] ?>
                    </span>
                <?php } ?>
                <?php if (isset($itemdata["count"])) { ?>
                    <span class="count">
                        <?= $itemdata["count"] ?>
                    </span>
                <?php } ?>

            </div>
        </div>
    </div>

<?php } ?>

<div id="sidemenu">

    <?php
    $sidemenu = navigation::sidemenu();

    foreach ($sidemenu as $menugroup) {

        if (!checkpermission($menugroup)) {
            continue;
        }

        //echo "<div class='text-xs text-light p-1'>" . $menugroup["title"] . "</div>";

        echo "<div class='sidemenu-itemgroup'>";
        // echo "<div class='sidemenu-itemgroup-title'>" . $menugroup["title"] . "</div>";

        foreach ($menugroup["items"] as $menuitem_key => $menuitem) {


            if (isset($menuitem['link'])) {
                sidemenu_linkitem($menuitem_key, $menuitem);
            } else if (isset($menuitem['links'])) { ?>

                <div class="sidemenu-subitem-group">

                    <input type="checkbox" id="sidemenu-<?= $menuitem_key ?>-toggle" <?= array_key_exists(page::get('nav-parent'), $menuitem['links']) ? "" : "checked" ?>>

                    <label for="sidemenu-<?= $menuitem_key ?>-toggle">

                        <div class="sidemenu-item <?= (checkpermission($menuitem)) ? "" : "disabled" ?>">

                            <div class="row sidemenu-content">
                                <div class="col icon">
                                    <?= UI::icon($menuitem['icon']) ?>
                                </div>
                                <div class="col text">
                                    <?= $menuitem['text'] ?>
                                </div>
                                <div class="col arrow">
                                    <?= (checkpermission($menuitem)) ? UI::icon("arrow-down") : UI::icon("lock") ?>
                                </div>
                            </div>
                        </div>

                    </label>

                    <div class="sidemenu-subitems" style="max-height:<?= count($menuitem['links']) * 2 ?>rem;">

                        <?php foreach ($menuitem['links'] as $key2 => $value) {
                            sidemenu_linkitem($key2, $value);
                        } ?>

                    </div>

                </div>

            <?php } ?>

    <?php }
        echo "</div>";
    } ?>

</div>



<a href="#menu-toggle" id="menu-toggle">
    <?= UI::icon("menu") ?>
</a>

<script>
    $("#menu-toggle").click(function(e) {
        $("#sidemenu").toggleClass("toggled");
    });
</script>

</div>