<?php

class cases extends datatable
{
    protected static $table = array(
        "name" => "cases",
        "primary" => "case_id",
        "creators" => "admin",
        "editors" => ""
    );

    protected static $data = array(
        "created_at" => [
            "locked" => true,
            "required" => true,
            "default" => "#timestamp"
        ],
        "created_by" => [
            "locked" => true,
            "required" => true,
            "default" => "#user"
        ],
        "last_updated_at" => [
            "locked" => true,
            "required" => true,
            "default" => "#timestamp"
        ],
        "last_updated_by" => [
            "locked" => true,
            "required" => true,
            "default" => "#user"
        ],
        "case_title" => [
            "required" => true,
            "default" => null
        ],
        "case_summary" => [
            "required" => true,
            "default" => null
        ],
        "case_file" => [
            "required" => true,
            "default" => null
        ],
        "informed_by" => [
            "required" => true,
            "default" => null
        ],
        "informed_at" => [
            "required" => true,
            "default" => null,
            "validators" => ["date"]
        ],
        "relevant_ins" => [
            "required" => true,
            "default" => null
        ],
        "state" => [
            "required" => true,
            "default" => 1
        ],

        "state_note" => [
            "required" => false,
            "default" => null
        ]
    );

    public static function states()
    {
        $query = datatable::query("select * from case_states order by state_id");

        if ($query['success'] && $query['count'] > 0) {
            return $query['data'];
        } else {
            return false;
        }
    }
}
