<?php

class comments extends datatable
{
    protected static $table = array(
        "name" => "comments",
        "primary" => "comment_id"
    );

    protected static $data = array(

        "comment_by" => [
            "default" => "#user"
        ],
        "comment_at" => [
            "default" => "#timestamp"
        ],
        "case_id" => [],
        "text" => []
    );

    public static function bycase($caseid)
    {
        $query = self::query("SELECT c.comment_id, c.comment_by, u.name as user_name,  DATE_FORMAT(c.comment_at, '%y %b %d') as date_text, DATE_FORMAT(c.comment_at, '%h:%m') as time_text, c.text from " . static::$table['name'] . " as c, users as u where c.comment_by = u.id and c.case_id = :case order by c.comment_at", ["case" => $caseid]);

        if ($query['success'] && $query['count'] > 0) {
            return $query['data'];
        } else {
            return [];
        }
    }
}
