<?php

abstract class database
{

    private static $connection = null;

    public static function connect($c)
    {
        if (self::$connection == null) {
            try {
                self::$connection = new PDO('mysql:host=' . $c['host'] . ';dbname=' . $c['database'], $c['username'], $c['password'], array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8mb4'));
            } catch (PDOException $error) {
                echo "Database Connection Failed";
                //echo 'Error :' . $error->getCode() . ' - ' . $error->getMessage();
                die();
            }
        }
    }

    public static function get()
    {
        return self::$connection;
    }

    public static function query($sql, $data = false)
    {
        $return['input'] = $data;

        //dbconnection::get()->query("SET SESSION SQL_BIG_SELECTS=1");

        $execute = dbconnection::get()->prepare($sql);

        if ($data) {
            $e = $execute->execute($data);
        } else {
            $e = $execute->execute();
        }

        if ($e) {
            $return['success'] = true;
            $return['data'] = $execute->fetchall(PDO::FETCH_ASSOC);
            $return['count'] = $execute->rowCount();
            if ($return['count'] == 0) {
                $return['empty'] = true;
            }
        } else {
            $return['success'] = false;
            $return['error'] = $execute->errorInfo()[2];
        }

        return $return;
    }
}
