<?php

class notes extends datatable
{
    protected static $table = array(
        "name" => "mis_letter_notes",
        "primary" => "id"
    );

    protected static $data = array(

        "user" => [
            "default" => "#user"
        ],
        "timestamp" => [
            "default" => "#timestamp"
        ],
        "date" => [
            "default" => "#timestamp"
        ],
        "letter" => [],
        "text" => []
    );

    public static function byletter($letterid)
    {
        $query = self::query("SELECT n.id, n.date, n.user, u.shortname as user_name,  DATE_FORMAT(n.timestamp, '%y %b %d') as date_text,DATE_FORMAT(n.timestamp, '%h:%m') as time_text, n.text as note from " . static::$table['name'] . " as n, users as u where n.user = u.id and n.letter = :letter order by n.date", ["letter" => $letterid]);

        if ($query['success'] && $query['count'] > 0) {
            return $query['data'];
        } else {
            return [];
        }
    }
}
