<?php

class users extends datatable
{
    protected static $table = array(
        "name" => "users",
        "primary" => "id"
    );

    protected static $data = array(
        "name" => [],
        "institution" => [],
        "designation" => [],
        "state" => [],
        "username" => [
            "validators" => ["username", "text_english"],
            "editor" => ["admin"]
        ],
        "password" => [
            "validators" => ["password"],
            "modifiers" => ["hashpassword"],
            "editor" => ["admin"]
        ],
        "lastseen" => [
            "vaidators" => ["datetime"]
        ]
    );

    public static function lastseen($id)
    {
        $response = self::query("select lastseen from " . static::$table['name'] . " where id = :id", ["id" => $id]);

        if ($response['count'] > 0) {
            return $response['data'][0]['lastseen'];
        } else {
            return false;
        }
    }

    public static function online()
    {
        $response = self::query("select count(id) as count from users as u where (u.lastseen > :now - INTERVAL 15 MINUTE)", ["now" => timestamp()]);

        if ($response['count'] > 0) {
            return $response['data'][0]['count'];
        } else {
            return false;
        }
    }


    public static function subject_officers($institution)
    {
        $response = self::query("SELECT u.id,u.name,u.shortname, u.code FROM users as u, mis_user_roles as r where u.id = r.user and r.role = 3 and u.state = 1 and u.institution = :institution order by u.code;", ["institution" => $institution]);

        if ($response['success']) {
            return $response['data'];
        }
    }

    public static function active_employees($institution)
    {
        $response = self::query("SELECT u.id,u.name,u.shortname, u.code FROM users as u where u.institution = :institution and state = 1 order by u.code", ["institution" => $institution]);

        if ($response['success']) {
            return $response['data'];
        }
    }


    public static function byinstitution()
    {
        $response = datatable::query("select i.id,i.name,i.shortname, count(u.id) as count from users as u, institutions as i where u.institution = i.id group by u.institution");

        if ($response['success'] && $response['count'] > 0) {
            return $response['data'];
        } else {
            return false;
        }
    }

    public static function employee_states()
    {
        $response = self::query("select * from mis_user_states order by id");

        if ($response['count'] > 0) {
            return $response['data'];
        } else {
            return false;
        }
    }

    public static function employee_state_text($stateid)
    {
        $response = self::query("select * from mis_user_states where id = :state", ["state" => $stateid]);

        if ($response['count'] > 0) {
            return $response['data'][0]["name"];
        } else {
            return false;
        }
    }
}
