<?php
//configuration data
require "../../../src/config.php";

page::set([
  "title" => "Inbox",
  "nav-parent" => "user_inbox",
  "layout" => "admin",
  "size" => "box-full",
]);

page::header();
?>

<div class="card">
  <div class="card-body">
    <div id="mail_list"></div>
  </div>
</div>
<script id="letter_template" type="text/template">

  <div class="datalist">

      {{#data}}

      <div class="listitem bg-state{{state}}" id="{{id}}">
        <div class="listitem-content">
        <div class="row">

            <div class="col col-w5 center">
              <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}">
                <div class="tag-id mt-1">{{id}}</div> 
                <div class="date-box mt-1">
                  <div class="month">{{received_month}}</div>
                  <div class="date">{{received_date}}</div>
                </div> 
              </a>
            </div>

            <div class="col">

              <div class="text-muted text-xs pb-1">
                {{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}} &nbsp; | &nbsp; {{source_name}}
              </div>

              <div class="text text-strong">{{title}}</div>
                
              <div class="py-1">

                {{#file_number}}
                  <a class="btn-addfile" href="../updatefile?id={{id}}"><?= UI::icon("file") ?> {{file_number}}</a>
                {{/file_number}}
                {{^file_number}}
                  <a class="btn-addfile" href="../updatefile?id={{id}}"><?= UI::icon("file") ?> Add to File</a>
                {{/file_number}}
                <a class="tag-primary" href="../notes?l={{id}}"><?= UI::icon("note") ?> Add note</a>


                {{#state_name}}
                
                <a class="" href="../updatestate?id={{id}}">
                  <span class="ms-2 text-strong progress-text-{{state}}">{{state_name}}<?= UI::icon("edit") ?></span>
                  <span class="text-edits"></span>
                </a>

                {{/state_name}}

              </div>

            </div>              

        </div>

        <div class="mt-1">
          {{#notes}}
          <div class="row">
            <div class="col col-w4 m-auto">
              <div class="text-muted text-xs float-end me-2" hidden>{{date}}</div>
            </div>                     
            <div class="col">
              <div class="text-xs">
                <div class="row">
                  <div class="col col-w2 center text-primary"><?= UI::icon("note") ?></div>
                  <div class="col">{{note}}</div>
                </div>
              </div>
            </div>
          </div>
          {{/notes}}
        </div>

        </div>

        </div>
      {{/data}}

    </div>

</script>

<script id="letter_template2" type="text/template">

  <div class="datalist text-sm">

      {{#data}}

          <div class="listitem bg-state{{state}}" id="{{id}}">

              <div class="listitem-content">

              <div class="row">

                  <div class="col col-w4 center">

                        <a href="/<?= SUBFOLDER ?>mail/letters/summary?id={{id}}">
                          <div class="tag-id w-100 my-2">{{id}}8888</div> 
                        </a>

                  </div>

                  <div class="col col-w6 center">

                    <a href="/<?= SUBFOLDER ?>mail/letters/summary?id={{id}}">
                      <div class="date-box">
                        <div class="month">{{received_month}}</div>
                        <div class="date">{{received_date}}</div>
                      </div> 
                    </a>

                  </div>

                  <div class="col">

                    <div class="text-muted text-xs pb-1">
                      {{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}} &nbsp; | &nbsp; {{source_name}}
                    </div>

                      <div class="text-md text-strong">{{title}}</div>
                      <div class="pt-1">

                      {{#file_number}}
                        <div class="tag-file text-sm"><?= UI::icon("file") ?> {{file_number}}</div>
                      {{/file_number}}

                      {{#state_name}}
                      <span class="text-success ms-2 text-strong">{{state_name}}</span>
                      {{/state_name}}
                      {{^state_name}}
                      <span class="text-danger text-strong"><?= UI::icon("warning") ?> ගත් පියවර යාවත්කාලීන කර නැත</span>
                      {{/state_name}}

                    </div>

                  </div>

                  <div class="col-12 col-lg-2 m-auto right">

                    <a href="/<?= SUBFOLDER ?>user/mail/update?id={{id}}" class="text-strong text-sm me-3">
                      <?= UI::icon("edit") ?> Update
                    </a> 
                    <a href="/<?= SUBFOLDER ?>mail/letters/summary/notes?l={{id}}" class="text-primary text-sm text-strong">
                      <?= UI::icon("note") ?> Add Note
                    </a>
                  </div>                  

              </div>

              {{#notes}}
              <div class="row my-2">
                <div class="col col-w6 text-sm text-primary">
                  <?= UI::icon("note") ?>
                </div>
                <div class="col-w4 m-auto">
                  <div class="text-muted text-xs">{{date}}</div>
                </div>                     
                <div class="col m-auto">
                  <div class="text-sm text-primary"><?= UI::icon("note") ?> {{note}}</div>
                </div>
              </div>
              {{/notes}}

            </div>

          </div>

      {{/data}}

    </div>

</script>



<script>
  var template = $("#letter_template").html();
  var data = [];

  $("#date_select").on("change", load);
  $("#search_text").on("input", filter);
  $("#date_select, #search_type").on("change", filter);

  function load() {

    $("#mail_list").html(UI_loading);

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month");
    if (!data[key]) {
      $.getJSON(API + "user/mail/inbox.php", {
        year: date.data("year"),
        month: date.data("month")
      }, function(response) {
        data[key] = response;
        $("#mail_list").html(Mustache.render(template, response));
        filter();
      });
    } else {
      $("#mail_list").html(Mustache.render(template, data[key]));
      filter();
    }

  }

  function filter() {

    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");

    var date = $("#date_select").find(":selected");
    var key = date.data("year") + "_" + date.data("month");

    $.each(data[key]["data"], function(key, value) {
      if (value[search_type].search(search_key) != -1) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }


  $(function() {
    if ($("#date_select").length > 0) {
      load();
    }
  });
</script>

<?php page::footer(); ?>