<?php
//configuration data
require "../../../src/config.php";

page::set([
  "title" => "Inbox",
  "nav-parent" => "user_mail_active",
  "layout" => "admin",
  "size" => "box-full",
]);

page::header();
?>

<!-- Modal -->
<div class="modal fade" id="myModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header center">
        <h5 class="modal-title" id="staticBackdropLabel">වර්තමාන තත්වය</h5>
      </div>
      <div class="modal-body">
        <div class="form-groups">
          <div class="radio-groups">
            <?php foreach (letters::states() as  $value) { ?>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="state" id="state<?= $value["id"] ?>" value="<?= $value["id"] ?>" required>
                <label class="form-check-label w-100" for="state<?= $value["id"] ?>">
                  <span class="text-md text-strong progress-text-<?= $value["id"] ?>">
                    <?= UI::icon("progress-state-" . $value["id"]) . " " . $value["name"] ?>
                  </span>
                </label>
              </div>

            <?php }  ?>
          </div>
        </div>

      </div>
      <div class="modal-footer center" id="modal-footer">
        <div class="row w-100">
          <div class="col p-1">
            <button type="button" class="btn btn-secondary btn-block" data-bs-dismiss="modal">Cancel</button>
          </div>
          <div class="col p-1">
            <button type="button" onclick="updatestate()" data-bs-dismiss="modal" id="updatestatebtn" class="btn btn-primary btn-block">Update</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-body">
    <div class="datalist">
      <div id="mail_list"></div>
    </div>
  </div>
</div>


<script id="template" type="text/template">

  <div class="listitem bg-state{{state}}" id="{{id}}">
      <div class="listitem-content py-2">
        <div class="row">
          <div class="col col-w5 px-2 center">
            <a href="/<?= SUBFOLDER ?>modules/mail/summary?id={{id}}">
              <div class="tag-id w-100">{{id}}</div> 
              <div class=" ">
                <div class="text-strong">{{received_month}} {{received_date}}</div>
              </div> 
              <div class="mt-1">
                {{#late}}<span class="tag-delayed text-sm">+{{late}} </span>{{/late}}
              </div> 
            </a>
          </div>

          <div class="col ps-2">

          <div class="text-muted text-xs pb-1">
            {{sender_name}} &nbsp; | &nbsp; {{date}} &nbsp; | &nbsp; {{number}} &nbsp; | &nbsp; {{source_name}}
          </div>

          <div class="text text-strong">{{title}}</div>
            
          <div class="pt-1">

            {{#file_number}}
              <a class="btn-addfile" href="../updatefile?id={{id}}"><?= UI::icon("file") ?> {{file_number}}</a>
            {{/file_number}}
            {{^file_number}}
              <a class="btn-addfile text-strong" href="../updatefile?id={{id}}"><?= UI::icon("file") ?> +</a>
            {{/file_number}}
            <a class="tag-primary" href="../notes?l={{id}}"><?= UI::icon("note") ?>+</a>

            {{#state_name}}
            
            <a href="javascript:void(0)" onclick="showModal({{id}},{{state}})">
              <span class="ms-2 text-strong progress-text-{{state}}">{{state_name}}<?= UI::icon("edit") ?></span>
            </a>

            {{/state_name}}

          </div>

          <div class="mt-1">
            {{#notes}}
            <div class="row mt-1">
              <div class="col col-w1">
                <div class="text-muted text-xs float-end text-primary"><?= UI::icon("note") ?></div>
              </div>                     
              <div class="col">
                <div class="text-xs">
                  {{note}}
                  </div>
              </div>
            </div>
            {{/notes}}
          </div>

        </div>   
      </div>
    </div>
  </div>
</script>

<script>
  var template = $("#template").html();
  var data = [];
  var active_letter;

  var myModal = new bootstrap.Modal(document.getElementById('myModal'))

  $(function() {
    $("#mail_list").html(UI_loading);
    $.getJSON(API + "user/mail/pending.php", function(response) {
      data = response.data;
      $("#mail_list").html("");
      data.forEach(element => {
        $("#mail_list").append(Mustache.render(template, element));
      });
    });
  });

  $("#search_text").on("input", filter);
  $("#search_type").on("change", filter);

  function filter() {

    var search_key = new RegExp($("#search_text").val(), "i");
    var search_type = $("#search_type").find(":selected").data("key");

    var state = $(".pill.active").data("category");

    $.each(data, function(key, value) {
      if (value[search_type].search(search_key) != -1 && (state == 0 || value.state == parseInt(state))) {
        $("#" + value.id).slideDown(200);
      } else {
        $("#" + value.id).slideUp(200);
      }
    });

  }

  function changecategory(category) {

    $(".pill").removeClass("active");
    $("#pill_" + category).addClass("active");
    filter();
  }

  function showModal(id, state) {
    active_letter = id;
    $('input[value="' + state + '"]').prop("checked", true)
    myModal.show();
  }

  function updatestate() {

    $("#" + active_letter).append(UI_loading);
    var letter = active_letter;
    var newstate = $("input[type='radio'][name=state]:checked").val();
    myModal.hide();

    $.getJSON(API + "user/mail/updatestate.php", {
      "id": active_letter,
      "newstate": newstate
    }, function(response) {
      data.forEach(function(element, index) {
        if (element.id == letter) {
          data[index] = response.data;
        }
      });
      $("#" + letter).html(Mustache.render(template, response.data));
    });

  }
</script>

<?php page::footer(); ?>