<?php
require "../../../src/config.php";

page::set([
    "title" => "Letters",
    "nav-parent" => "mail_userletters",
    "layout" => "admin",
    "size" => "box-full",
    "scripts" => ["chosen"]
]);

if (isset($_GET['id'])) {
    $letter = letters::get($_GET['id']);
    if (!$letter) {
        error("Invalid URL");
    }
} else {
    error("Invalid URL");
}

if (page::submitted()) {
    $letter = $_POST;

    if (isset($_GET['id'])) {
        $response = letters::update($_GET['id'], $letter);
        if ($response["success"]) {
            header("Location: /" . SUBFOLDER . "mail/letters/summary?id=" . $_GET["id"]);
        }
    }
}

page::header();

?>

<form method="post" class="card">

    <div class="card-top">
        <div class="title"> <?= isset($_GET["id"]) ? "Update Letter #" . $_GET["id"] : "Add New Letter" ?></div>
    </div>

    <div class="card-body">

        <?php
        if (page::submitted()) {
            form::response_summary($response);
        }

        ?>

        <div class="form-group">
            <label for="sender">File</label>
            <select name="sender" id="sender" class=" ">
                <option value="0">ගොනුවකට එක්කර නොමැත</option>
                <?php
                foreach (files::byuser() as $value) {
                    echo '<option value="' . $value['id'] . '" ' . ($value["id"] == $letter["file"] ? "selected" : "") . '>' . $value['number'] . ' ' . $value['name'] . '</option>';
                } ?>
            </select>
        </div>

        <div class="form-group">
            <label for="state">State</label>
            <div class="radio-group">
                <?php foreach (letters::states() as  $value) { ?>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="state" id="state<?= $value["id"] ?>" value="<?= $value["id"] ?>" <?= $value["id"] == $letter["state"] ? "checked" : "" ?> autofocus required>
                        <label class="form-check-label w-100" for="state<?= $value["id"] ?>">
                            <?= $value["name"] ?>
                        </label>
                    </div>

                <?php }  ?>
            </div>
        </div>

    </div>

    <div class="card-bottom">

        <div class="row">
            <div class="col-6">
                <button type="submit" class="btn btn-primary btn-block">Update</button>
            </div>
            <div class="col-6">
                <a href="../" class="btn btn-secondary btn-block">Back</a>
            </div>
        </div>

    </div>

</form>

<script>
    $("#sender").chosen({
        width: "100%"
    });

    $("#sender").on("change", function() {
        if (this.value != 0) {
            $("#sender2").text("");
            $("#sender2").prop("disabled", true);
            $("#sender2_block").slideUp(200);
        } else {
            $("#sender2").prop("disabled", false);
            $("#sender2_block").slideDown(200);
        }
    });

    $('input[name = "source"]').on("change", function() {

        if (this.value != 2) {
            $("#ref").prop("disabled", true);
            $("#ref-block").slideUp(300);
        } else {
            $("#ref").prop("disabled", false);
            $("#ref-block").slideDown(300);
        }
    });

    //$('input[name = "source"]').trigger("change");

    $('form').submit(function() {
        $(".card-bottom").html(UI_loading);
    });

    $(function() {
        $("#sender").trigger("change");
    });
</script>

<?php page::footer(); ?>