<?php
require "../../../src/config.php";

page::set([
    "title" => "Letters",
    "nav-parent" => "mail_userletters",
    "layout" => "admin",
    "size" => "box-full",
    "scripts" => ["pickday", "chosen"]
]);

if (isset($_GET['id'])) {
    $data = letters::get($_GET['id']);
    if (!$data) {
        error("Invalid URL");
    }
} else {
    error("Invalid URL");
}

if (page::submitted()) {
    $data = $_POST;

    if (isset($_GET['id'])) {
        $response = letters::update($_GET['id'], $data);
        if ($response["success"]) {
            header("Location: /" . SUBFOLDER . "modules/mail/summary?id=" . $_GET["id"]);
        }
    }
}

page::header();

?>

<form method="post" class="card">

    <div class="card-top">
        <div class="title"> <?= isset($_GET["id"]) ? "Update Letter #" . $_GET["id"] : "Add New Letter" ?></div>
    </div>

    <div class="card-body">

        <?php
        if (page::submitted()) {
            form::response_summary($response);
        }

        ?>

        <div class="form-group py-2">
            <label for="source">File</label>
            <div class="radio-group radio-group-labels">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="file" id="file0" value="0" <?= $data["file"] == 0 ? "checked" : "" ?> required>
                    <label class="form-check-label" for="file0">
                        <div class="p-2 center text-strong text-md">
                            ගොනුවකට එක්කර නොමැත
                        </div>
                    </label>
                </div>

                <?php display(files::byuser()) ?>
                <?php

                if (files::byuser()) {
                    foreach (files::byuser() as  $value) { ?>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="file" id="file<?= $value["id"] ?>" value="<?= $value["id"] ?>" <?= $value["id"] == $data["file"] ? "checked" : "" ?> required>
                            <label class="form-check-label" for="file<?= $value["id"] ?>">
                                <div class="row p-1">
                                    <div class="col col-4">
                                        <span class="tag-file w-100"><?= UI::icon("file") ?><?= $value["number"] ?></span>
                                    </div>
                                    <div class="col m-auto ps-2">
                                        <?= $value["name"] ?>
                                    </div>
                                </div>
                            </label>
                        </div>

                <?php }
                }

                alert::announcement([
                    "text" => "You Haven't Added any files",
                    "content" => ["sdsd", "sdss"]
                ]);
                ?>


            </div>
        </div>

    </div>

    <div class="card-bottom">

        <div class="row">
            <div class="col-6">
                <button type="submit" class="btn btn-primary btn-block">Update</button>
            </div>
            <div class="col-6">
                <a href="../" class="btn btn-secondary btn-block">Back</a>
            </div>
        </div>

    </div>

</form>

<script>
    $("#sender").chosen({
        width: "100%"
    });

    var picker_received = new Pikaday({
        field: document.getElementById('received'),
    });

    var picker_date = new Pikaday({
        field: document.getElementById('date'),
    });


    $("#sender").on("change", function() {
        if (this.value != 0) {
            $("#sender2").text("");
            $("#sender2").prop("disabled", true);
            $("#sender2_block").slideUp(200);
        } else {
            $("#sender2").prop("disabled", false);
            $("#sender2_block").slideDown(200);
        }
    });

    $('input[name = "source"]').on("change", function() {

        if (this.value != 2) {
            $("#ref").prop("disabled", true);
            $("#ref-block").slideUp(300);
        } else {
            $("#ref").prop("disabled", false);
            $("#ref-block").slideDown(300);
        }
    });

    //$('input[name = "source"]').trigger("change");

    $('form').submit(function() {
        $(".card-bottom").html(UI_loading);
    });

    $(function() {
        $("#sender").trigger("change");
    });
</script>

<?php page::footer(); ?>